#include <SPI.h>
#include <Adafruit_GFX.h>
#include <Max72xxPanel.h>

// config horloge

#include <Wire.h>
#include "RTClib.h"

#if defined(ARDUINO_ARCH_SAMD)
// for Zero, output on USB Serial console, remove line below if using programming port to program the Zero!
   #define Serial SerialUSB
#endif

RTC_DS1307 rtc;

String SVan = "";
String SVmois = "";
String TVmois ="";
String SVjour ="";
String SNVjour = " ";
String SVheure = "";
String SVmn ="";
String SVsec ="";

int Vmois = 0;

char daysOfTheWeek[7][12] = {"Dimanche", "Lundi", "Mardi", "Mercredi", "Jeudi", "Vendredi", "Samedi"};
char tous_mois[12][10] = { "Janvier", "Février", "Mars", "Avril", "Mai", "Juin", "Juillet", "Aout", "Septembre", "Octobre", "Novembre", "Decembre"};

// fin config horloge

int pinCS = 10; // Attach CS to this pin, DIN to MOSI and CLK to SCK (cf http://arduino.cc/en/Reference/SPI )
int numberOfHorizontalDisplays = 1;
int numberOfVerticalDisplays = 8;

Max72xxPanel matrix = Max72xxPanel(pinCS, numberOfHorizontalDisplays, numberOfVerticalDisplays);

String tape = "Bonjour tous le monde. Nous sommes le ";
int wait = 20; // In milliseconds

int spacer = 1;
int width = 5 + spacer; // The font width is 5 pixels

void setup() {

  // config horloge
#ifndef ESP8266
  while (!Serial); // for Leonardo/Micro/Zero
#endif

  Serial.begin(57600);
  if (! rtc.begin()) {
    Serial.println("Couldn't find RTC");
    while (1);
  }

  if ( ! rtc.isrunning()) {
    Serial.println("RTC is NOT running!");
    // following line sets the RTC to the date & time this sketch was compiled
    rtc.adjust(DateTime(F(__DATE__), F(__TIME__)));
    // This line sets the RTC with an explicit date & time, for example to set
    // January 21, 2014 at 3am you would call:
     //rtc.adjust(DateTime(2017, 3, 8, 22, 46, 30));
  }

  // fin config   horloge
  

  matrix.setIntensity(1); // Use a value between 0 and 15 for brightness

// Adjust to your own needs
//  matrix.setPosition(0, 0, 0); // The first display is at <0, 0>
//  matrix.setPosition(1, 1, 0); // The second display is at <1, 0>
//  matrix.setPosition(2, 2, 0); // The third display is at <2, 0>
//  matrix.setPosition(3, 3, 0); // And the last display is at <3, 0>
//  ...
  matrix.setRotation(3);    // The first display is position upside down
//  matrix.setRotation(3, 2);    // The same hold for the last display
}

void loop() {

  // config horloge
DateTime now = rtc.now();


    SVan = now.year();
    SVmois = now.month();
    Vmois = now.month();
    TVmois = tous_mois[Vmois - 1];
    SVjour = now.day();
    SVheure= now.hour();
    SVmn = now.minute();
    SVsec = now.second();
    SNVjour = daysOfTheWeek[now.dayOfTheWeek()];

 
    Serial.println(TVmois);

    tape = "Bonjour a tous. Nous sommes le ";
    tape = tape + SNVjour + " " + SVjour + " " + TVmois + " " + SVan + " " + " a " + SVheure +"h" + " "+ SVmn+"mn"+ " "+ SVsec + "s" ;
    delay(1000);

  // fin congig horloge

  for ( int i = 0 ; i < width * tape.length() + matrix.width() - 1 - spacer; i++ ) {

    matrix.fillScreen(LOW);

    int letter = i / width;
    int x = (matrix.width() - 1) - i % width;
    int y = (matrix.height() - 8) / 2; // center the text vertically

    while ( x + width - spacer >= 0 && letter >= 0 ) {
      if ( letter < tape.length() ) {
        matrix.drawChar(x, y, tape[letter], HIGH, LOW, 1);
      }

      letter--;
      x -= width;
    }

    matrix.write(); // Send bitmap to display

    delay(wait);
  }
}

