import turtle

# Initialisation de la fenêtre turtle
fenetre = turtle.Screen()
fenetre.bgcolor("white")

# Initialisation de la tortue
t = turtle.Turtle()
t.speed(2)

# Fonction pour dessiner un cercle
def dessiner_cercle(rayon):
    t.penup()
    t.goto(0, -rayon)  # Placer la tortue en bas du cercle
    t.pendown()
    t.circle(rayon)  # Dessiner le cercle avec le rayon spécifié

# Fonction pour dessiner un rectangle autour du cercle
def dessiner_rectangle(rayon):
    largeur = 2 * rayon  # Le rectangle doit avoir la même largeur que le diamètre du cercle
    hauteur = 2 * rayon  # Le rectangle doit avoir la même hauteur que le diamètre du cercle
    t.penup()
    t.goto(-rayon, rayon)  # Placer la tortue au coin supérieur gauche du rectangle
    t.pendown()
    
    for _ in range(2):
        t.forward(largeur)
        t.right(90)
        t.forward(hauteur)
        t.right(90)

# Paramètre du cercle
rayon_cercle = 100

# Dessiner le cercle
dessiner_cercle(rayon_cercle)

# Dessiner le rectangle autour du cercle
dessiner_rectangle(rayon_cercle)

# Cacher la tortue après le dessin
t.hideturtle()

# Maintenir la fenêtre ouverte
turtle.done()


