//  _ ___ _______     ___ ___ ___  ___ _   _ ___ _____ ___ 
// / |_  )__ /   \   / __|_ _| _ \/ __| | | |_ _|_   _/ __| 
// | |/ / |_ \ |) | | (__ | ||   / (__| |_| || |  | | \__ \ 
// |_/___|___/___/   \___|___|_|_\\___|\___/|___| |_| |___/ 
// 
// TP4 S4 MOOC Feux Barrierre bouton GL 24042016
// 
// Made by Gerard Laumonier
// License: CC-BY-SA 3.0
// Downloaded from: https://123d.circuits.io/circuits/2023456-tp4-s4-mooc-feux-barrierre-bouton-gl-24042016


/*
S4 TP4 MOOC FUN Feux Barriere Bouton par G laumonier

Le fonctionnement normal est un feu allumé au rouge et une barrière fermée (0°). Le fonctionnement normal est interrompu par l'appui sur un bouton poussoir.
Si l'appui du bouton est détecté, alors la barrière (actionnée par le servomoteur) se relève doucement. Lorsque la barrière est à la verticale (90°), le feu vert s'allume pendant 5 secondes pendant lesquelles la barrière reste ouverte (90°). Après les 5 secondes, le feu repasse au rouge, la barrière redescend doucement et le fonctionnement normal reprend.
Aussi, nous souhaitons recevoir le message "Bouton appuye" dans le moniteur série lorsque l'appui a été détecté.

- Un servomoteur qui jouera le rôle de barrière (branché sur les broches 9, +5V et GND)
- Un bouton pour demander l'ouverture de la barrière (branché sur la broche 2)
- Un feu bicolore qui passera au vert lorsque la barrière sera complètement ouverte
avec une LED rouge sur la broche 3 en serie avec une resistance de 220Ω
avec une LED verte sur la broche 4 en serie avec une resistance de 220Ω
*/

// nomme la broche 3 Ledrouge permet de gagner quelques octets etc ...
#define Ledrouge 3 		
#define Ledverte 4		
#define Bouton_barriere 2
#define Servo_moteur 9


// inclue la librairie Servo.h dans la compilation du programme
#include <Servo.h>	

int etat_bouton = 0; // Variable pour determiner si le bouton est appuyé = 1 ou relache = 0

Servo monservo;  // déclare la variable monservo à partir de la librairie Servo

const int barriere_haute = 90; // constante qui  determine l'angle du servo moteur  de la barriere position haute  c'est à dire 90° 
const int barriere_basse = 0; // constante qui determine l'angle du servo moteur de la barriere position basse  c'est à dire 0°


void setup() {
  Serial.begin(9600); // initialise la vitesse de communication du port série entre le PC et l'arduino  à 9600 Bds
  pinMode(Ledrouge,OUTPUT); // declare la broche Ledrouge ( 3) en sortie
  pinMode(Ledverte,OUTPUT);
  pinMode(Bouton_barriere, INPUT);// declare la broche Bouton_barriere (2) en entrée 

  monservo.attach(Servo_moteur); // attache la variable monservo à la broche 9 ( Servo_moteur)

  digitalWrite(Ledrouge,HIGH); // En implicite la Led rouge est allumée

  for ( int i = barriere_haute; i>= barriere_basse; i+= -5)// en implicite La barriere est mise en position fermée angle = 0°
     {
      monservo.write(i);		// on fait bouger le servo moteur de l'angle voulu 
      delay(30);
     }
  delay(1000);// on attend 1 seconde pour laisser le temps au servo moteur de se positionner
  monservo.detach(); // on detache la variable monservo de la broche 9 pour eviter de laisser le servo moteur sous tension pour rien
}



void loop() {

etat_bouton = digitalRead(Bouton_barriere); // on met la valeur du bouton dans la variable etat_bouton 1 = bouton appuyé , 0 bouton relaché

if (etat_bouton == 1) // on test si le bouton est appuyé , si le bouton n'est pas appuyé on ne fait rien ==> Led Rouge allumée et barriere fermée
{
  monservo.attach(Servo_moteur); // on attache la variable monservo à la broche 9 pour qu'il puisse etre actif
  Serial.println("Bouton detecte...");// on envoie le texte "Bouton detecté" sur le terminal arduino du PC 
  Serial.println("-----------------");// pour etre sur que l'on à bien à nouveau l'info

   for (int i = barriere_basse; i<= barriere_haute; i+=5) // on ouvre la barriere lentement pas d'un seul coup avec la boucle for 
   {													  // qui va de l'angle 0° à l'angel 90°
    monservo.write(i);							
    delay(30);											  // ce petit delais permet au servo moteur de se positionner
   }
    delay(1000); 										// on attend que le servo moteur se positionne
    digitalWrite(Ledrouge, LOW);						// on eteind la LED rouge
    digitalWrite(Ledverte, HIGH);						// on allume la LED verte
    delay(5000);										// on attend 5 s
    digitalWrite(Ledverte,LOW);							// On eteind la LED verte
    digitalWrite(Ledrouge,HIGH);						// on allume la LED rouge
    delay(1000);										// on attend 1 s que tout le monde soit passé

    for (int i = barriere_haute; i>= barriere_basse; i+=-5)	// on ferme la barriere on  part de  l'ange 90° ( ouverte ) à l'ange 0° ( fermée)
   {
    monservo.write(i);
    delay(30);
   }
   monservo.detach(); // arrette le servo moteur
 }

}

 
 
