/*
 * Decompiled with CFR 0.152.
 */
package com.ardublock.translator.block;

import com.ardublock.translator.Translator;
import com.ardublock.translator.block.NumberBlock;
import com.ardublock.translator.block.TranslatorBlock;
import com.ardublock.translator.block.exception.BlockException;
import com.ardublock.translator.block.exception.SocketNullException;
import com.ardublock.translator.block.exception.SubroutineNotDeclaredException;

public class ServoDefaultBlock
extends TranslatorBlock {
    public ServoDefaultBlock(Long blockId, Translator translator, String codePrefix, String codeSuffix, String label) {
        super(blockId, translator, codePrefix, codeSuffix, label);
    }

    public String toCode() throws SocketNullException, SubroutineNotDeclaredException {
        TranslatorBlock tb = this.getRequiredTranslatorBlockAtSocket(0);
        String servoSpecs = "";
        if (!(tb instanceof NumberBlock)) {
            throw new BlockException(this.blockId, "the Pin# of Servo must be a number");
        }
        String pinNumber = tb.toCode();
        String servoName = "servo_pin_" + pinNumber;
        tb = this.getRequiredTranslatorBlockAtSocket(1);
        String ret = servoName + ".write( " + tb.toCode() + " );\n";
        this.translator.addHeaderFile("Servo.h");
        this.translator.addDefinitionCommand("Servo " + servoName + ";");
        this.translator.addSetupCommand(servoName + ".attach(" + pinNumber + servoSpecs + ");");
        return ret;
    }
}

