/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.blocks.codeblocks;

import edu.mit.blocks.codeblocks.Block;
import edu.mit.blocks.codeblocks.BlockConnector;
import edu.mit.blocks.codeblocks.BlockShape;
import edu.mit.blocks.codeblocks.rendering.BlockShapeUtil;
import edu.mit.blocks.renderable.RenderableBlock;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.util.ArrayList;

public class InfixBlockShape
extends BlockShape {
    private float maxX = 0.0f;

    public InfixBlockShape(RenderableBlock rb) {
        super(rb);
    }

    @Override
    protected void makeBottomSide() {
        this.maxX = 0.0f;
        this.setEndPoint(this.gpBottom, this.botLeftCorner, this.topLeftCorner, true);
        BlockShapeUtil.cornerTo(this.gpBottom, this.botLeftCorner, this.botRightCorner, this.blockCornerRadius);
        int socketCounter = 0;
        for (BlockConnector curSocket : this.block.getSockets()) {
            if (curSocket.getPositionType() != BlockConnector.PositionType.BOTTOM) continue;
            if (socketCounter > 0) {
                this.gpBottom.lineTo((float)this.gpBottom.getCurrentPoint().getX() + 16.0f, (float)this.gpBottom.getCurrentPoint().getY());
            } else {
                this.gpBottom.lineTo((float)this.gpBottom.getCurrentPoint().getX() + 10.0f, (float)this.gpBottom.getCurrentPoint().getY());
            }
            BlockShapeUtil.lineToRelative(this.gpBottom, 0.0f, -0.1f);
            if (curSocket.getBlockID() == Block.NULL) {
                Point2D leftSocket = BCS.addDataSocketUp(this.gpBottom, curSocket.getKind(), true);
                this.rb.updateSocketPoint(curSocket, leftSocket);
                this.gpBottom.lineTo((float)this.gpBottom.getCurrentPoint().getX() + 10.0f, (float)this.gpBottom.getCurrentPoint().getY());
                BCS.addDataSocket(this.gpBottom, curSocket.getKind(), false);
            } else {
                Block connectedBlock = this.rb.getWorkspace().getEnv().getBlock(curSocket.getBlockID());
                RenderableBlock connectedRBlock = this.rb.getWorkspace().getEnv().getRenderableBlock(curSocket.getBlockID());
                double unzoomX = connectedRBlock.getSocketPixelPoint(connectedBlock.getPlug()).getX() / connectedRBlock.getZoom();
                double unzoomY = connectedRBlock.getSocketPixelPoint(connectedBlock.getPlug()).getY() / connectedRBlock.getZoom();
                Point2D.Double connectedBlockSocketPoint = new Point2D.Double(unzoomX, unzoomY);
                Point2D currentPoint = this.gpBottom.getCurrentPoint();
                double newX = ((Point2D)connectedBlockSocketPoint).getX() + Math.abs(((Point2D)connectedBlockSocketPoint).getX() - currentPoint.getX());
                double newY = ((Point2D)connectedBlockSocketPoint).getY() + Math.abs((double)connectedRBlock.getBlockHeight() / connectedRBlock.getZoom() - currentPoint.getY());
                this.rb.updateSocketPoint(curSocket, new Point2D.Double(newX, newY));
                BlockShape connectedBlockShape = this.rb.getWorkspace().getEnv().getRenderableBlock(curSocket.getBlockID()).getBlockShape();
                this.appendPath(this.gpBottom, connectedBlockShape.getLeftSide(), false);
                if (connectedBlock.getNumSockets() == 0 || connectedBlock.isInfix()) {
                    this.appendPath(this.gpBottom, connectedBlockShape.getTopSide(), false);
                    this.appendPath(this.gpBottom, connectedBlockShape.getRightSide(), false);
                } else {
                    this.appendRightSidePath(this.gpBottom, connectedBlock, connectedBlockShape);
                }
                if (this.maxX < (float)this.gpBottom.getCurrentPoint().getX()) {
                    this.maxX = (float)this.gpBottom.getCurrentPoint().getX();
                }
                this.gpBottom.lineTo(this.maxX, (float)this.gpBottom.getCurrentPoint().getY());
            }
            BlockShapeUtil.lineToRelative(this.gpBottom, 0.0f, 0.1f);
            if (socketCounter < this.block.getNumSockets() - 1) {
                this.gpBottom.lineTo((float)this.gpBottom.getCurrentPoint().getX() + 16.0f + (float)this.rb.accomodateLabelsWidth(), (float)this.gpBottom.getCurrentPoint().getY());
            } else {
                this.gpBottom.lineTo((float)this.gpBottom.getCurrentPoint().getX() + 10.0f, (float)this.gpBottom.getCurrentPoint().getY());
            }
            ++socketCounter;
        }
        BlockShapeUtil.cornerTo(this.gpBottom, this.botRightCorner, this.topRightCorner, this.blockCornerRadius);
        this.setEndPoint(this.gpBottom, this.botRightCorner, this.topRightCorner, false);
    }

    private void appendRightSidePath(GeneralPath gpBottom, Block connectedBlock, BlockShape connectedBlockShape) {
        this.appendPath(gpBottom, connectedBlockShape.getTopSide(), false);
        float startX = (float)gpBottom.getCurrentPoint().getX();
        for (BlockConnector socket : connectedBlock.getSockets()) {
            gpBottom.lineTo(startX, (float)gpBottom.getCurrentPoint().getY());
            if (socket.getBlockID() == Block.NULL) {
                gpBottom.lineTo((float)gpBottom.getCurrentPoint().getX() + 10.0f, (float)gpBottom.getCurrentPoint().getY());
                BCS.addDataSocket(gpBottom, socket.getKind(), false);
            } else {
                Block block = this.rb.getWorkspace().getEnv().getBlock(socket.getBlockID());
                BlockShape shape = this.rb.getWorkspace().getEnv().getRenderableBlock(socket.getBlockID()).getBlockShape();
                if (block.getNumSockets() == 0 || block.isInfix()) {
                    this.appendPath(gpBottom, shape.getTopSide(), false);
                    this.appendPath(gpBottom, shape.getRightSide(), false);
                } else {
                    this.appendRightSidePath(gpBottom, block, shape);
                }
            }
            if (this.maxX < (float)gpBottom.getCurrentPoint().getX()) {
                this.maxX = (float)gpBottom.getCurrentPoint().getX();
            }
            gpBottom.lineTo(this.maxX, (float)gpBottom.getCurrentPoint().getY());
        }
    }

    @Override
    protected int determineBlockWidth() {
        int width = super.determineBlockWidth();
        int bottomSocketWidth = 0;
        for (BlockConnector socket : this.block.getSockets()) {
            if (socket.getPositionType() != BlockConnector.PositionType.BOTTOM) continue;
            if (socket.getBlockID() == Block.NULL) {
                bottomSocketWidth = (int)((float)bottomSocketWidth + 10.0f);
                continue;
            }
            if (this.rb.getSocketSpaceDimension(socket) != null) {
                bottomSocketWidth += this.rb.getSocketSpaceDimension((BlockConnector)socket).width;
            }
            bottomSocketWidth = (int)((float)bottomSocketWidth - 8.0f);
            if (this.rb.getWorkspace().getEnv().getBlock(socket.getBlockID()).getPlug().getPositionType() != BlockConnector.PositionType.MIRROR) continue;
            bottomSocketWidth = (int)((float)bottomSocketWidth - 8.0f);
        }
        bottomSocketWidth = (int)((float)bottomSocketWidth + 32.0f);
        if ((bottomSocketWidth = (int)((float)bottomSocketWidth + 20.0f)) > width) {
            return bottomSocketWidth + this.rb.accomodateLabelsWidth();
        }
        if ((width += bottomSocketWidth) % 2 == 1) {
            ++width;
        }
        return width;
    }

    private void appendPath(GeneralPath gp1, GeneralPath gp2, boolean reversed) {
        ArrayList<Number[]> points = new ArrayList<Number[]>();
        PathIterator i = gp2.getPathIterator(new AffineTransform());
        float[] segment = new float[]{0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f};
        float leftmost = Float.POSITIVE_INFINITY;
        while (!i.isDone()) {
            int type = i.currentSegment(segment);
            i.next();
            points.add(new Number[]{new Integer(type), new Float(segment[0]), new Float(segment[1]), new Float(segment[2]), new Float(segment[3]), new Float(segment[4]), new Float(segment[5])});
        }
        if (!reversed) {
            float deltaX = (float)gp1.getCurrentPoint().getX() - ((Float)((Number[])points.get(0))[1]).floatValue();
            float deltaY = (float)gp1.getCurrentPoint().getY() - ((Float)((Number[])points.get(0))[2]).floatValue();
            for (int j = 1; j < points.size(); ++j) {
                Object[] typeAndPoints = (Object[])points.get(j);
                int type = (Integer)typeAndPoints[0];
                float x1 = ((Float)typeAndPoints[1]).floatValue();
                float y1 = ((Float)typeAndPoints[2]).floatValue();
                float x2 = ((Float)typeAndPoints[3]).floatValue();
                float y2 = ((Float)typeAndPoints[4]).floatValue();
                float x3 = ((Float)typeAndPoints[5]).floatValue();
                float y3 = ((Float)typeAndPoints[6]).floatValue();
                if (type == 0) continue;
                if (type == 1) {
                    gp1.lineTo(x1 + deltaX, y1 + deltaY);
                    leftmost = Math.min(leftmost, x1 + deltaX);
                    continue;
                }
                if (type == 2) {
                    gp1.quadTo(x1 + deltaX, y1 + deltaY, x2 + deltaX, y2 + deltaY);
                    leftmost = Math.min(leftmost, x2 + deltaX);
                    continue;
                }
                if (type == 3) {
                    gp1.curveTo(x1 + deltaX, y1 + deltaY, x2 + deltaX, y2 + deltaY, x3 + deltaX, y3 + deltaY);
                    leftmost = Math.min(leftmost, x3 + deltaX);
                    continue;
                }
                assert (false) : type;
            }
        }
    }
}

