/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.blocks.codeblockutil;

public class XMLStringWriter {
    private StringBuffer contents = new StringBuffer();
    private static final String space = " ";
    private static final String equals = "=";
    private static final String quotes = "\"";
    private static final String nextline = "\n";
    private static final String lt = "<";
    private static final String gt = ">";
    private static final String slashlt = "</";
    private String indent = " ";
    private int currentIndent = 1;
    private String root = null;

    public XMLStringWriter(int indent) {
        while (indent > 1) {
            this.indent = this.indent + space;
            --indent;
        }
    }

    public XMLStringWriter() {
        this(4);
    }

    public void appendXMLWriterString(XMLStringWriter writer) {
        this.appendIndent();
        this.contents.append(writer.toString());
    }

    private void appendBegElement(String ele) {
        this.contents.append(lt);
        this.contents.append(ele);
        this.contents.append(gt);
    }

    private void appendEndElement(String ele) {
        this.contents.append(slashlt);
        this.contents.append(ele);
        this.contents.append(gt);
    }

    private void appendIndent() {
        for (int temp = this.currentIndent; temp > 1; --temp) {
            this.contents.append(this.indent);
        }
    }

    public void beginXMLString(String root) {
        this.contents.append(lt);
        this.contents.append(root);
        this.contents.append(gt);
        this.contents.append(nextline);
        ++this.currentIndent;
        this.root = root;
    }

    public void endXMLString() {
        this.contents.append(slashlt);
        this.contents.append(this.root);
        this.contents.append(gt);
    }

    public void addDataElement(String ele, String text) {
        this.appendIndent();
        this.appendBegElement(ele);
        this.contents.append(text);
        this.appendEndElement(ele);
        this.contents.append(nextline);
    }

    public void beginElement(String ele, boolean hasAttributes) {
        this.appendIndent();
        if (hasAttributes) {
            this.contents.append(lt);
            this.contents.append(ele);
        } else {
            this.appendBegElement(ele);
            this.contents.append(nextline);
        }
        ++this.currentIndent;
    }

    public void addElementTextData(String data) {
        this.contents.append(data);
    }

    public void addAttribute(String key, String value) {
        this.contents.append(space);
        this.contents.append(key);
        this.contents.append(equals);
        this.contents.append(quotes);
        this.contents.append(value);
        this.contents.append(quotes);
    }

    public void endAttributes() {
        this.contents.append(gt);
    }

    public void endElement(String ele) {
        this.appendEndElement(ele);
        this.contents.append(nextline);
    }

    public String toString() {
        return this.contents.toString();
    }
}

