/*
 * Decompiled with CFR 0.152.
 */
package com.ardublock.ui.listener;

import com.ardublock.core.Context;
import com.ardublock.translator.AutoFormat;
import com.ardublock.translator.Translator;
import com.ardublock.translator.block.exception.BlockException;
import com.ardublock.translator.block.exception.SocketNullException;
import com.ardublock.translator.block.exception.SubroutineNameDuplicatedException;
import com.ardublock.translator.block.exception.SubroutineNotDeclaredException;
import edu.mit.blocks.codeblocks.Block;
import edu.mit.blocks.renderable.RenderableBlock;
import edu.mit.blocks.workspace.Workspace;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class GenerateCodeButtonListener
implements ActionListener {
    private JFrame parentFrame;
    private Context context;
    private Workspace workspace;
    private ResourceBundle uiMessageBundle;

    public GenerateCodeButtonListener(JFrame frame, Context context) {
        this.parentFrame = frame;
        this.context = context;
        this.workspace = context.getWorkspaceController().getWorkspace();
        this.uiMessageBundle = ResourceBundle.getBundle("com/ardublock/block/ardublock");
    }

    public void actionPerformed(ActionEvent e) {
        Long blockId;
        Set<RenderableBlock> subroutineBlockSet;
        boolean success = true;
        Translator translator = new Translator(this.workspace);
        translator.reset();
        Set<RenderableBlock> loopBlockSet = translator.findEntryBlocks();
        try {
            subroutineBlockSet = translator.findSubroutineBlocks();
        }
        catch (SubroutineNameDuplicatedException e4) {
            Iterable<RenderableBlock> rbs = this.workspace.getRenderableBlocks();
            String subroutineName = null;
            for (RenderableBlock rb : rbs) {
                if (!rb.getBlockID().equals(e4.getBlockId())) continue;
                subroutineName = rb.getBlock().getBlockLabel().trim();
                break;
            }
            for (RenderableBlock rb : rbs) {
                if (!rb.getBlock().getBlockLabel().trim().equals(subroutineName)) continue;
                this.context.highlightBlock(rb);
            }
            JOptionPane.showMessageDialog(this.parentFrame, this.uiMessageBundle.getString("ardublock.translator.exception.subroutineNameDuplicated"), "Error", 0);
            return;
        }
        if (loopBlockSet.size() == 0) {
            JOptionPane.showMessageDialog(this.parentFrame, this.uiMessageBundle.getString("ardublock.translator.exception.noLoopFound"), "Error", 0);
            return;
        }
        if (loopBlockSet.size() > 1) {
            for (RenderableBlock rb : loopBlockSet) {
                this.context.highlightBlock(rb);
            }
            JOptionPane.showMessageDialog(this.parentFrame, this.uiMessageBundle.getString("ardublock.translator.exception.multipleLoopFound"), "Error", 0);
            return;
        }
        String code = "";
        try {
            code = translator.translate(loopBlockSet, subroutineBlockSet);
        }
        catch (SocketNullException e1) {
            success = false;
            blockId = e1.getBlockId();
            Iterable<RenderableBlock> blocks = this.workspace.getRenderableBlocks();
            for (RenderableBlock renderableBlock2 : blocks) {
                Block block2 = renderableBlock2.getBlock();
                if (!block2.getBlockID().equals(blockId)) continue;
                this.context.highlightBlock(renderableBlock2);
                break;
            }
            JOptionPane.showMessageDialog(this.parentFrame, this.uiMessageBundle.getString("ardublock.translator.exception.socketNull"), "Error", 0);
        }
        catch (BlockException e2) {
            e2.printStackTrace();
            success = false;
            blockId = e2.getBlockId();
            Iterable<RenderableBlock> blocks = this.workspace.getRenderableBlocks();
            for (RenderableBlock renderableBlock2 : blocks) {
                Block block2 = renderableBlock2.getBlock();
                if (!block2.getBlockID().equals(blockId)) continue;
                this.context.highlightBlock(renderableBlock2);
                break;
            }
            JOptionPane.showMessageDialog(this.parentFrame, e2.getMessage(), "Error", 0);
        }
        catch (SubroutineNotDeclaredException e3) {
            success = false;
            blockId = e3.getBlockId();
            Iterable<RenderableBlock> blocks = this.workspace.getRenderableBlocks();
            for (RenderableBlock renderableBlock3 : blocks) {
                Block block2 = renderableBlock3.getBlock();
                if (!block2.getBlockID().equals(blockId)) continue;
                this.context.highlightBlock(renderableBlock3);
                break;
            }
            JOptionPane.showMessageDialog(this.parentFrame, this.uiMessageBundle.getString("ardublock.translator.exception.subroutineNotDeclared"), "Error", 0);
        }
        if (success) {
            AutoFormat formatter = new AutoFormat();
            String codeOut = code.toString();
            this.context.getClass();
            codeOut = formatter.format(codeOut);
            if (!this.context.isInArduino()) {
                System.out.println(codeOut);
            }
            this.context.didGenerate(codeOut);
        }
    }
}

