/*
 * Decompiled with CFR 0.152.
 */
package processing.app.debug;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import processing.app.Base;
import processing.app.Preferences;
import processing.app.Sketch;
import processing.app.SketchCode;
import processing.app.debug.MessageConsumer;
import processing.app.debug.MessageSiphon;
import processing.app.debug.MessageStream;
import processing.app.debug.RunnerException;
import processing.app.debug.Target;
import processing.core.PApplet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Compiler
implements MessageConsumer {
    static final String BUGS_URL = "http://code.google.com/p/arduino/issues/list";
    static final String SUPER_BADNESS = "Compiler error, please submit this code to http://code.google.com/p/arduino/issues/list";
    Sketch sketch;
    String buildPath;
    String primaryClassName;
    boolean verbose;
    RunnerException exception;
    boolean firstErrorFound;
    boolean secondErrorFound;

    public boolean compile(Sketch sketch, String buildPath, String primaryClassName, boolean verbose) throws RunnerException {
        String corePath;
        File coreFolder;
        Target t;
        this.sketch = sketch;
        this.buildPath = buildPath;
        this.primaryClassName = primaryClassName;
        this.verbose = verbose;
        MessageStream pms = new MessageStream(this);
        String avrBasePath = Base.getAvrBasePath();
        Map<String, String> boardPreferences = Base.getBoardPreferences();
        String core = boardPreferences.get("build.core");
        if (core == null) {
            RunnerException re = new RunnerException("No board selected; please choose a board from the Tools > Board menu.");
            re.hideStackTrace();
            throw re;
        }
        if (core.indexOf(58) == -1) {
            t = Base.getTarget();
            coreFolder = new File(new File(t.getFolder(), "cores"), core);
            corePath = coreFolder.getAbsolutePath();
        } else {
            t = Base.targetsTable.get(core.substring(0, core.indexOf(58)));
            coreFolder = new File(t.getFolder(), "cores");
            coreFolder = new File(coreFolder, core.substring(core.indexOf(58) + 1));
            corePath = coreFolder.getAbsolutePath();
        }
        String variant = boardPreferences.get("build.variant");
        String variantPath = null;
        if (variant != null) {
            File variantFolder;
            Target t2;
            if (variant.indexOf(58) == -1) {
                t2 = Base.getTarget();
                variantFolder = new File(new File(t2.getFolder(), "variants"), variant);
                variantPath = variantFolder.getAbsolutePath();
            } else {
                t2 = Base.targetsTable.get(variant.substring(0, variant.indexOf(58)));
                variantFolder = new File(t2.getFolder(), "variants");
                variantFolder = new File(variantFolder, variant.substring(variant.indexOf(58) + 1));
                variantPath = variantFolder.getAbsolutePath();
            }
        }
        ArrayList<File> objectFiles = new ArrayList<File>();
        sketch.setCompilingProgress(20);
        ArrayList<File> includePaths = new ArrayList<File>();
        includePaths.add((File)((Object)corePath));
        if (variantPath != null) {
            includePaths.add((File)((Object)variantPath));
        }
        for (File file : sketch.getImportedLibraries()) {
            includePaths.add((File)((Object)file.getPath()));
        }
        sketch.setCompilingProgress(30);
        objectFiles.addAll(this.compileFiles(avrBasePath, buildPath, includePaths, Compiler.findFilesInPath(buildPath, "S", false), Compiler.findFilesInPath(buildPath, "c", false), Compiler.findFilesInPath(buildPath, "cpp", false), boardPreferences));
        sketch.setCompilingProgress(40);
        for (File libraryFolder : sketch.getImportedLibraries()) {
            File outputFolder = new File(buildPath, libraryFolder.getName());
            File utilityFolder = new File(libraryFolder, "utility");
            Compiler.createFolder(outputFolder);
            includePaths.add((File)((Object)utilityFolder.getAbsolutePath()));
            objectFiles.addAll(this.compileFiles(avrBasePath, outputFolder.getAbsolutePath(), includePaths, Compiler.findFilesInFolder(libraryFolder, "S", false), Compiler.findFilesInFolder(libraryFolder, "c", false), Compiler.findFilesInFolder(libraryFolder, "cpp", false), boardPreferences));
            outputFolder = new File(outputFolder, "utility");
            Compiler.createFolder(outputFolder);
            objectFiles.addAll(this.compileFiles(avrBasePath, outputFolder.getAbsolutePath(), includePaths, Compiler.findFilesInFolder(utilityFolder, "S", false), Compiler.findFilesInFolder(utilityFolder, "c", false), Compiler.findFilesInFolder(utilityFolder, "cpp", false), boardPreferences));
            includePaths.remove(includePaths.size() - 1);
        }
        sketch.setCompilingProgress(50);
        includePaths.clear();
        includePaths.add((File)((Object)corePath));
        if (variantPath != null) {
            includePaths.add((File)((Object)variantPath));
        }
        List<File> coreObjectFiles = this.compileFiles(avrBasePath, buildPath, includePaths, Compiler.findFilesInPath(corePath, "S", true), Compiler.findFilesInPath(corePath, "c", true), Compiler.findFilesInPath(corePath, "cpp", true), boardPreferences);
        String runtimeLibraryName = buildPath + File.separator + "core.a";
        ArrayList<String> baseCommandAR = new ArrayList<String>(Arrays.asList(avrBasePath + "avr-ar", "rcs", runtimeLibraryName));
        for (File file : coreObjectFiles) {
            ArrayList<String> commandAR = new ArrayList<String>(baseCommandAR);
            commandAR.add(file.getAbsolutePath());
            this.execAsynchronously(commandAR);
        }
        sketch.setCompilingProgress(60);
        ArrayList<String> baseCommandLinker = new ArrayList<String>(Arrays.asList(avrBasePath + "avr-gcc", "-Os", "-Wl,--gc-sections", "-mmcu=" + boardPreferences.get("build.mcu"), "-o", buildPath + File.separator + primaryClassName + ".elf"));
        for (File file : objectFiles) {
            baseCommandLinker.add(file.getAbsolutePath());
        }
        baseCommandLinker.add(runtimeLibraryName);
        baseCommandLinker.add("-L" + buildPath);
        baseCommandLinker.add("-lm");
        this.execAsynchronously(baseCommandLinker);
        ArrayList<String> baseCommandObjcopy = new ArrayList<String>(Arrays.asList(avrBasePath + "avr-objcopy", "-O", "-R"));
        sketch.setCompilingProgress(70);
        ArrayList<String> commandObjcopy = new ArrayList<String>(baseCommandObjcopy);
        commandObjcopy.add(2, "ihex");
        commandObjcopy.set(3, "-j");
        commandObjcopy.add(".eeprom");
        commandObjcopy.add("--set-section-flags=.eeprom=alloc,load");
        commandObjcopy.add("--no-change-warnings");
        commandObjcopy.add("--change-section-lma");
        commandObjcopy.add(".eeprom=0");
        commandObjcopy.add(buildPath + File.separator + primaryClassName + ".elf");
        commandObjcopy.add(buildPath + File.separator + primaryClassName + ".eep");
        this.execAsynchronously(commandObjcopy);
        sketch.setCompilingProgress(80);
        commandObjcopy = new ArrayList<String>(baseCommandObjcopy);
        commandObjcopy.add(2, "ihex");
        commandObjcopy.add(".eeprom");
        commandObjcopy.add(buildPath + File.separator + primaryClassName + ".elf");
        commandObjcopy.add(buildPath + File.separator + primaryClassName + ".hex");
        this.execAsynchronously(commandObjcopy);
        sketch.setCompilingProgress(90);
        return true;
    }

    private List<File> compileFiles(String avrBasePath, String buildPath, List<File> includePaths, List<File> sSources, List<File> cSources, List<File> cppSources, Map<String, String> boardPreferences) throws RunnerException {
        String objectPath;
        ArrayList<File> objectPaths = new ArrayList<File>();
        for (File file : sSources) {
            objectPath = buildPath + File.separator + file.getName() + ".o";
            objectPaths.add(new File(objectPath));
            this.execAsynchronously(Compiler.getCommandCompilerS(avrBasePath, includePaths, file.getAbsolutePath(), objectPath, boardPreferences));
        }
        for (File file : cSources) {
            objectPath = buildPath + File.separator + file.getName() + ".o";
            objectPaths.add(new File(objectPath));
            this.execAsynchronously(Compiler.getCommandCompilerC(avrBasePath, includePaths, file.getAbsolutePath(), objectPath, boardPreferences));
        }
        for (File file : cppSources) {
            objectPath = buildPath + File.separator + file.getName() + ".o";
            objectPaths.add(new File(objectPath));
            this.execAsynchronously(Compiler.getCommandCompilerCPP(avrBasePath, includePaths, file.getAbsolutePath(), objectPath, boardPreferences));
        }
        return objectPaths;
    }

    private void execAsynchronously(List commandList) throws RunnerException {
        Process process;
        String[] command = new String[commandList.size()];
        commandList.toArray(command);
        int result = 0;
        if (this.verbose || Preferences.getBoolean("build.verbose")) {
            for (int j = 0; j < command.length; ++j) {
                System.out.print(command[j] + " ");
            }
            System.out.println();
        }
        this.firstErrorFound = false;
        this.secondErrorFound = false;
        try {
            process = Runtime.getRuntime().exec(command);
        }
        catch (IOException e) {
            RunnerException re = new RunnerException(e.getMessage());
            re.hideStackTrace();
            throw re;
        }
        MessageSiphon in = new MessageSiphon(process.getInputStream(), this);
        MessageSiphon err = new MessageSiphon(process.getErrorStream(), this);
        boolean compiling = true;
        while (compiling) {
            try {
                if (in.thread != null) {
                    in.thread.join();
                }
                if (err.thread != null) {
                    err.thread.join();
                }
                result = process.waitFor();
                compiling = false;
            }
            catch (InterruptedException ignored) {}
        }
        if (this.exception != null) {
            throw this.exception;
        }
        if (result > 1) {
            System.err.println(command[0] + " returned " + result);
        }
        if (result != 0) {
            RunnerException re = new RunnerException("Error compiling.");
            re.hideStackTrace();
            throw re;
        }
    }

    @Override
    public void message(String s) {
        String errorFormat;
        String[] pieces;
        if (!this.verbose) {
            int i;
            while ((i = s.indexOf(this.buildPath + File.separator)) != -1) {
                s = s.substring(0, i) + s.substring(i + (this.buildPath + File.separator).length());
            }
        }
        if ((pieces = PApplet.match((String)s, (String)(errorFormat = "([\\w\\d_]+.\\w+):(\\d+):\\s*error:\\s*(.*)\\s*"))) != null) {
            RunnerException e;
            String error = pieces[3];
            String msg = "";
            if (pieces[3].trim().equals("SPI.h: No such file or directory")) {
                error = "Please import the SPI library from the Sketch > Import Library menu.";
                msg = "\nAs of Arduino 0019, the Ethernet library depends on the SPI library.\nYou appear to be using it or another library that depends on the SPI library.\n\n";
            }
            if (pieces[3].trim().equals("'BYTE' was not declared in this scope")) {
                error = "The 'BYTE' keyword is no longer supported.";
                msg = "\nAs of Arduino 1.0, the 'BYTE' keyword is no longer supported.\nPlease use Serial.write() instead.\n\n";
            }
            if (pieces[3].trim().equals("no matching function for call to 'Server::Server(int)'")) {
                error = "The Server class has been renamed EthernetServer.";
                msg = "\nAs of Arduino 1.0, the Server class in the Ethernet library has been renamed to EthernetServer.\n\n";
            }
            if (pieces[3].trim().equals("no matching function for call to 'Client::Client(byte [4], int)'")) {
                error = "The Client class has been renamed EthernetClient.";
                msg = "\nAs of Arduino 1.0, the Client class in the Ethernet library has been renamed to EthernetClient.\n\n";
            }
            if (pieces[3].trim().equals("'Udp' was not declared in this scope")) {
                error = "The Udp class has been renamed EthernetUdp.";
                msg = "\nAs of Arduino 1.0, the Udp class in the Ethernet library has been renamed to EthernetClient.\n\n";
            }
            if (pieces[3].trim().equals("'class TwoWire' has no member named 'send'")) {
                error = "Wire.send() has been renamed Wire.write().";
                msg = "\nAs of Arduino 1.0, the Wire.send() function was renamed to Wire.write() for consistency with other libraries.\n\n";
            }
            if (pieces[3].trim().equals("'class TwoWire' has no member named 'receive'")) {
                error = "Wire.receive() has been renamed Wire.read().";
                msg = "\nAs of Arduino 1.0, the Wire.receive() function was renamed to Wire.read() for consistency with other libraries.\n\n";
            }
            if ((e = this.sketch.placeException(error, pieces[1], PApplet.parseInt((String)pieces[2]) - 1)) != null && !this.verbose) {
                SketchCode code = this.sketch.getCode(e.getCodeIndex());
                String fileName = code.isExtension(this.sketch.getDefaultExtension()) ? code.getPrettyName() : code.getFileName();
                s = fileName + ":" + e.getCodeLine() + ": error: " + pieces[3] + msg;
            }
            if (this.exception == null && e != null) {
                this.exception = e;
                this.exception.hideStackTrace();
            }
        }
        System.err.print(s);
    }

    private static List getCommandCompilerS(String avrBasePath, List includePaths, String sourceName, String objectName, Map<String, String> boardPreferences) {
        ArrayList<String> baseCommandCompiler = new ArrayList<String>(Arrays.asList(avrBasePath + "avr-gcc", "-c", "-g", "-assembler-with-cpp", "-mmcu=" + boardPreferences.get("build.mcu"), "-DF_CPU=" + boardPreferences.get("build.f_cpu"), "-DARDUINO=100"));
        for (int i = 0; i < includePaths.size(); ++i) {
            baseCommandCompiler.add("-I" + (String)includePaths.get(i));
        }
        baseCommandCompiler.add(sourceName);
        baseCommandCompiler.add("-o" + objectName);
        return baseCommandCompiler;
    }

    private static List getCommandCompilerC(String avrBasePath, List includePaths, String sourceName, String objectName, Map<String, String> boardPreferences) {
        ArrayList<String> baseCommandCompiler = new ArrayList<String>(Arrays.asList(avrBasePath + "avr-gcc", "-c", "-g", "-Os", "-w", "-ffunction-sections", "-fdata-sections", "-mmcu=" + boardPreferences.get("build.mcu"), "-DF_CPU=" + boardPreferences.get("build.f_cpu"), "-DARDUINO=100"));
        for (int i = 0; i < includePaths.size(); ++i) {
            baseCommandCompiler.add("-I" + (String)includePaths.get(i));
        }
        baseCommandCompiler.add(sourceName);
        baseCommandCompiler.add("-o" + objectName);
        return baseCommandCompiler;
    }

    private static List getCommandCompilerCPP(String avrBasePath, List includePaths, String sourceName, String objectName, Map<String, String> boardPreferences) {
        ArrayList<String> baseCommandCompilerCPP = new ArrayList<String>(Arrays.asList(avrBasePath + "avr-g++", "-c", "-g", "-Os", "-w", "-fno-exceptions", "-ffunction-sections", "-fdata-sections", "-mmcu=" + boardPreferences.get("build.mcu"), "-DF_CPU=" + boardPreferences.get("build.f_cpu"), "-DARDUINO=100"));
        for (int i = 0; i < includePaths.size(); ++i) {
            baseCommandCompilerCPP.add("-I" + (String)includePaths.get(i));
        }
        baseCommandCompilerCPP.add(sourceName);
        baseCommandCompilerCPP.add("-o" + objectName);
        return baseCommandCompilerCPP;
    }

    private static void createFolder(File folder) throws RunnerException {
        if (folder.isDirectory()) {
            return;
        }
        if (!folder.mkdir()) {
            throw new RunnerException("Couldn't create: " + folder);
        }
    }

    public static String[] headerListFromIncludePath(String path) {
        FilenameFilter onlyHFiles = new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.endsWith(".h");
            }
        };
        return new File(path).list(onlyHFiles);
    }

    public static ArrayList<File> findFilesInPath(String path, String extension, boolean recurse) {
        return Compiler.findFilesInFolder(new File(path), extension, recurse);
    }

    public static ArrayList<File> findFilesInFolder(File folder, String extension, boolean recurse) {
        ArrayList<File> files = new ArrayList<File>();
        if (folder.listFiles() == null) {
            return files;
        }
        for (File file : folder.listFiles()) {
            if (file.getName().startsWith(".")) continue;
            if (file.getName().endsWith("." + extension)) {
                files.add(file);
            }
            if (!recurse || !file.isDirectory()) continue;
            files.addAll(Compiler.findFilesInFolder(file, extension, true));
        }
        return files;
    }
}

