package com.ardublock.translator.block.network;

import com.ardublock.translator.Translator;
import com.ardublock.translator.block.TranslatorBlock;
import com.ardublock.translator.block.exception.SocketNullException;
import com.ardublock.translator.block.exception.SubroutineNotDeclaredException;

public class BLEShield extends TranslatorBlock {

	public BLEShield(Long blockId, Translator translator, String codePrefix, String codeSuffix, String label) {
		super(blockId, translator, codePrefix, codeSuffix, label);
	}

	@Override
	public String toCode() throws SocketNullException, SubroutineNotDeclaredException {
		String DataPin;
		String IRQpin;
		TranslatorBlock translatorBlock = this.getRequiredTranslatorBlockAtSocket(0);
		DataPin = translatorBlock.toCode();
		translatorBlock = this.getRequiredTranslatorBlockAtSocket(1);
		IRQpin = translatorBlock.toCode();
		translator.addHeaderFile("SoftwareSerial.h");
		translator.addDefinitionCommand("SoftwareSerial bleShield("+DataPin+","+ IRQpin+");");
		translator.addSetupCommand("bleShield.begin(19200);");
		return "";
	}

}
