/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.blocks.renderable;

import edu.mit.blocks.codeblocks.BlockConnector;
import edu.mit.blocks.codeblocks.BlockConnectorShape;
import edu.mit.blocks.renderable.BlockLabel;
import edu.mit.blocks.renderable.RenderableBlock;
import edu.mit.blocks.workspace.Workspace;
import java.awt.Color;

class NameLabel
extends BlockLabel {
    private long blockID;

    public NameLabel(Workspace workspace, String initLabelText, BlockLabel.Type labelType, boolean isEditable, long blockID) {
        super(workspace, initLabelText, labelType, isEditable, blockID, true, new Color(255, 255, 225));
        this.blockID = blockID;
    }

    void update() {
        RenderableBlock rb = this.workspace.getEnv().getRenderableBlock(this.blockID);
        if (rb != null) {
            int x = 0;
            int y = 0;
            if (rb.getBlock().isCommandBlock()) {
                x += 5;
            }
            if (rb.getBlock().isDeclaration()) {
                x += 12;
            }
            if (rb.getBlock().hasPlug()) {
                x += 4 + BlockConnectorShape.getConnectorDimensions((BlockConnector)rb.getBlock().getPlug()).width;
            }
            if (rb.getBlock().isInfix()) {
                x = !rb.getBlock().getSocketAt(0).hasBlock() ? (x += 30) : (x += rb.getSocketSpaceDimension((BlockConnector)rb.getBlock().getSocketAt((int)0)).width);
            }
            y = rb.getBlockWidget() == null ? (y += rb.getAbstractBlockArea().getBounds().height / 2) : (y += 12);
            if (rb.getBlock().isCommandBlock()) {
                y -= 2;
            }
            if (rb.getBlock().hasPageLabel() && rb.getBlock().hasAfterConnector()) {
                y = (int)((float)y - 4.0f);
            }
            if (!rb.getBlock().hasPageLabel()) {
                y -= this.getAbstractHeight() / 2;
            }
            x += rb.getControlLabelsWidth();
            y = (int)((float)y + (rb.isCollapsed() ? 2.0f : 0.0f));
            x = this.rescale(x);
            y = this.rescale(y);
            this.setPixelLocation(x, y);
        }
    }
}

