/*
 * Decompiled with CFR 0.152.
 */
package com.ardublock;

import com.ardublock.core.Context;
import com.ardublock.ui.ArduBlockToolFrame;
import com.ardublock.ui.listener.OpenblocksFrameListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import processing.app.Editor;
import processing.app.tools.Tool;

public class ArduBlockToolMaxi
implements Tool,
OpenblocksFrameListener {
    static Editor editor;
    static ArduBlockToolFrame openblocksFrame;

    public void init(Editor editor) {
        if (ArduBlockToolMaxi.editor == null) {
            ArduBlockToolMaxi.editor = editor;
            openblocksFrame = new ArduBlockToolFrame();
            openblocksFrame.addListener(this);
            Context context = Context.getContext();
            String arduinoVersion = this.getArduinoVersion();
            context.setInArduino(true);
            context.setArduinoVersionString(arduinoVersion);
            context.setEditor(editor);
            System.out.println("Arduino Version: " + arduinoVersion);
        }
    }

    public void run() {
        try {
            editor.toFront();
            openblocksFrame.setVisible(true);
            openblocksFrame.toFront();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getMenuTitle() {
        return "ArduBlock Maxi";
    }

    public void didSave() {
    }

    public void didLoad() {
    }

    public void didSaveAs() {
    }

    public void didNew() {
    }

    public void didGenerate(String source) {
        editor.setText(source);
        editor.handleExport(false);
    }

    private String getArduinoVersion() {
        Context context = Context.getContext();
        File versionFile = context.getArduinoFile("lib/version.txt");
        if (versionFile.exists()) {
            String line;
            block8: {
                block7: {
                    FileInputStream is = new FileInputStream(versionFile);
                    BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)is, "UTF-8"));
                    line = reader.readLine();
                    reader.close();
                    if (line != null) break block7;
                    return "unknown";
                }
                line = line.trim();
                if (line.length() != 0) break block8;
                return "unknown";
            }
            try {
                return line;
            }
            catch (FileNotFoundException e) {
                return "unknown";
            }
            catch (UnsupportedEncodingException e) {
                return "unknown";
            }
            catch (IOException e) {
                e.printStackTrace();
                return "unknown";
            }
        }
        return "unknown";
    }
}

