/*
 * Decompiled with CFR 0.152.
 */
package com.ardublock.core;

import com.ardublock.ui.listener.OpenblocksFrameListener;
import edu.mit.blocks.codeblocks.Block;
import edu.mit.blocks.controller.WorkspaceController;
import edu.mit.blocks.renderable.FactoryRenderableBlock;
import edu.mit.blocks.renderable.RenderableBlock;
import edu.mit.blocks.workspace.FactoryManager;
import edu.mit.blocks.workspace.Page;
import edu.mit.blocks.workspace.Workspace;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.ResourceBundle;
import java.util.Set;
import processing.app.Editor;

public class Context {
    public static final String LANG_DTD_PATH = "/com/ardublock/block/lang_def.dtd";
    public static final String ARDUBLOCK_LANG_PATH = "/com/ardublock/block/ardublock.xml";
    public static final String DEFAULT_ARDUBLOCK_PROGRAM_PATH = "/com/ardublock/default.abp";
    public static final String ARDUINO_VERSION_UNKNOWN = "unknown";
    public final boolean isNeedAutoFormat = true;
    private static Context singletonContext;
    private boolean workspaceChanged;
    private boolean workspaceEmpty;
    private Set<RenderableBlock> highlightBlockSet;
    private Set<OpenblocksFrameListener> ofls;
    private boolean isInArduino = false;
    private String arduinoVersionString = "unknown";
    private OsType osType;
    public static final String APP_NAME = "ArduBlock Mini";
    private Editor editor;
    private String saveFilePath;
    private String saveFileName;
    private WorkspaceController workspaceController = new WorkspaceController();
    private Workspace workspace;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Context getContext() {
        if (singletonContext != null) return singletonContext;
        Class<Context> clazz = Context.class;
        synchronized (Context.class) {
            if (singletonContext != null) return singletonContext;
            singletonContext = new Context();
            // ** MonitorExit[var0] (shouldn't be in output)
            return singletonContext;
        }
    }

    private Context() {
        this.resetWorksapce();
        this.workspace = this.workspaceController.getWorkspace();
        this.workspaceChanged = false;
        this.highlightBlockSet = new HashSet<RenderableBlock>();
        this.ofls = new HashSet<OpenblocksFrameListener>();
        this.workspace = this.workspaceController.getWorkspace();
        this.isInArduino = false;
        this.osType = this.determineOsType();
    }

    public void resetWorksapce() {
        String[][] styles;
        ArrayList<String[]> list = new ArrayList<String[]>();
        String[][] stringArrayArray = styles = new String[0][];
        int n = styles.length;
        int n2 = 0;
        while (n2 < n) {
            String[] style = stringArrayArray[n2];
            list.add(style);
            ++n2;
        }
        this.workspaceController.resetWorkspace();
        this.workspaceController.resetLanguage();
        this.workspaceController.setLangResourceBundle(ResourceBundle.getBundle("com/ardublock/block/ardublock"));
        this.workspaceController.setStyleList(list);
        this.workspaceController.setLangDefDtd(this.getClass().getResourceAsStream(LANG_DTD_PATH));
        this.workspaceController.setLangDefStream(this.getClass().getResourceAsStream(ARDUBLOCK_LANG_PATH));
        this.workspaceController.loadFreshWorkspace();
        this.loadDefaultArdublockProgram();
        this.saveFilePath = null;
        this.saveFileName = "untitled";
        this.workspaceEmpty = true;
    }

    private void loadDefaultArdublockProgram() {
        Workspace workspace = this.workspaceController.getWorkspace();
        Page page = workspace.getPageNamed("Main");
        FactoryManager manager = workspace.getFactoryManager();
        Block newBlock = new Block(workspace, "loop", false);
        FactoryRenderableBlock factoryRenderableBlock = new FactoryRenderableBlock(workspace, manager, newBlock.getBlockID());
        RenderableBlock renderableBlock = factoryRenderableBlock.createNewInstance();
        renderableBlock.setLocation(100, 100);
        page.addBlock(renderableBlock);
    }

    private OsType determineOsType() {
        String osName = System.getProperty("os.name");
        if ((osName = osName.toLowerCase()).contains("win")) {
            return OsType.WINDOWS;
        }
        if (osName.contains("linux")) {
            return OsType.LINUX;
        }
        if (osName.contains("mac")) {
            return OsType.MAC;
        }
        return OsType.UNKNOWN;
    }

    public File getArduinoFile(String name) {
        String javaroot;
        String path = System.getProperty("user.dir");
        if (this.osType.equals((Object)OsType.MAC) && (javaroot = System.getProperty("javaroot")) != null) {
            path = javaroot;
        }
        File workingDir = new File(path);
        return new File(workingDir, name);
    }

    public WorkspaceController getWorkspaceController() {
        return this.workspaceController;
    }

    public Workspace getWorkspace() {
        return this.workspace;
    }

    public boolean isWorkspaceChanged() {
        return this.workspaceChanged;
    }

    public void setWorkspaceChanged(boolean workspaceChanged) {
        this.workspaceChanged = workspaceChanged;
    }

    public void highlightBlock(RenderableBlock block) {
        block.updateInSearchResults(true);
        this.highlightBlockSet.add(block);
    }

    public void cancelHighlightBlock(RenderableBlock block) {
        block.updateInSearchResults(false);
        this.highlightBlockSet.remove(block);
    }

    public void resetHightlightBlock() {
        for (RenderableBlock rb : this.highlightBlockSet) {
            rb.updateInSearchResults(false);
        }
        this.highlightBlockSet.clear();
    }

    public void saveArduBlockFile(File saveFile, String saveString) throws IOException {
        if (!saveFile.exists()) {
            saveFile.createNewFile();
        }
        FileOutputStream fos = new FileOutputStream(saveFile, false);
        fos.write(saveString.getBytes("UTF8"));
        fos.flush();
        fos.close();
        this.didSave();
    }

    public void loadArduBlockFile(File savedFile) throws IOException {
        if (savedFile != null) {
            this.saveFilePath = savedFile.getAbsolutePath();
            this.saveFileName = savedFile.getName();
            this.workspaceController.resetWorkspace();
            this.workspaceController.loadProjectFromPath(this.saveFilePath);
            this.didLoad();
        }
    }

    public void setEditor(Editor e) {
        this.editor = e;
    }

    public Editor getEditor() {
        return this.editor;
    }

    public boolean isInArduino() {
        return this.isInArduino;
    }

    public void setInArduino(boolean isInArduino) {
        this.isInArduino = isInArduino;
    }

    public String getArduinoVersionString() {
        return this.arduinoVersionString;
    }

    public void setArduinoVersionString(String arduinoVersionString) {
        this.arduinoVersionString = arduinoVersionString;
    }

    public OsType getOsType() {
        return this.osType;
    }

    public void registerOpenblocksFrameListener(OpenblocksFrameListener ofl) {
        this.ofls.add(ofl);
    }

    public void didSave() {
        for (OpenblocksFrameListener ofl : this.ofls) {
            ofl.didSave();
        }
    }

    public void didLoad() {
        for (OpenblocksFrameListener ofl : this.ofls) {
            ofl.didLoad();
        }
    }

    public void didGenerate(String sourcecode) {
        for (OpenblocksFrameListener ofl : this.ofls) {
            ofl.didGenerate(sourcecode);
        }
    }

    public String getSaveFileName() {
        return this.saveFileName;
    }

    public void setSaveFileName(String saveFileName) {
        this.saveFileName = saveFileName;
    }

    public String getSaveFilePath() {
        return this.saveFilePath;
    }

    public void setSaveFilePath(String saveFilePath) {
        this.saveFilePath = saveFilePath;
    }

    public boolean isWorkspaceEmpty() {
        return this.workspaceEmpty;
    }

    public void setWorkspaceEmpty(boolean workspaceEmpty) {
        this.workspaceEmpty = workspaceEmpty;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OsType {
        LINUX,
        MAC,
        WINDOWS,
        UNKNOWN;

    }
}

