/*
 * Decompiled with CFR 0.152.
 */
package com.ardublock.translator.block.scoop;

import com.ardublock.translator.Translator;
import com.ardublock.translator.block.TranslatorBlock;
import com.ardublock.translator.block.exception.SocketNullException;
import com.ardublock.translator.block.exception.SubroutineNotDeclaredException;

public class SCoopTaskBlock
extends TranslatorBlock {
    private static int taskId = 0;

    public SCoopTaskBlock(Long blockId, Translator translator, String codePrefix, String codeSuffix, String label) {
        super(blockId, translator, codePrefix, codeSuffix, label);
    }

    public String toCode() throws SocketNullException, SubroutineNotDeclaredException {
        StringBuffer setupCodeBuffer = new StringBuffer();
        TranslatorBlock translatorBlock = this.getTranslatorBlockAtSocket(0);
        while (translatorBlock != null) {
            setupCodeBuffer.append(translatorBlock.toCode());
            translatorBlock = translatorBlock.nextTranslatorBlock();
        }
        StringBuffer loopCodeBuffer = new StringBuffer();
        translatorBlock = this.getTranslatorBlockAtSocket(1);
        while (translatorBlock != null) {
            loopCodeBuffer.append(translatorBlock.toCode());
            translatorBlock = translatorBlock.nextTranslatorBlock();
        }
        return this.generateScoopTask(setupCodeBuffer.toString(), loopCodeBuffer.toString());
    }

    String generateScoopTask(String setupCommand, String loopCommand) {
        this.translator.addHeaderFile("SCoop.h");
        this.translator.addSetupCommand("mySCoop.start();");
        String taskName = SCoopTaskBlock.createScoopTaskName();
        String ret = "defineTask(" + taskName + ")\n" + "void " + taskName + "::setup()\n" + "{\n";
        ret = String.valueOf(ret) + setupCommand;
        ret = String.valueOf(ret) + "}\n\n" + "void " + taskName + "::loop()\n" + "{\n";
        ret = String.valueOf(ret) + loopCommand;
        ret = String.valueOf(ret) + "}\n\n";
        return ret;
    }

    public static String createScoopTaskName() {
        return "scoopTask" + ++taskId;
    }
}

