/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.blocks.codeblocks;

import edu.mit.blocks.codeblocks.Block;
import edu.mit.blocks.codeblocks.BlockConnector;
import edu.mit.blocks.codeblocks.BlockLink;
import edu.mit.blocks.codeblocks.BlockStub;
import edu.mit.blocks.workspace.Workspace;
import edu.mit.blocks.workspace.WorkspaceEvent;
import edu.mit.blocks.workspace.WorkspaceWidget;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ProcedureOutputManager {
    private static Workspace workspace;
    private static final int DEFAULT_SIZE = 5;
    private static final Map<Long, OutputInfo> myProcInfo;
    public static final String VM_COMMAND_NAME = "vm-cmd-name";
    public static final String CMD_EVAL_PROCEDURE = "eval-procedure";
    public static final String RUNTIME_TYPE = "runtime-type";

    static {
        myProcInfo = new HashMap<Long, OutputInfo>();
    }

    public ProcedureOutputManager(Workspace wworkspace) {
        workspace = wworkspace;
    }

    public static void procedureUpdateInfo(WorkspaceEvent event) {
        Block b = ProcedureOutputManager.getBlock(event.getSourceBlockID());
        BlockLink link = event.getSourceLink();
        switch (event.getEventType()) {
            case 5: {
                if (link != null) {
                    ProcedureOutputManager.blocksConnected(event.getSourceWidget(), link.getSocketBlockID(), link.getPlugBlockID());
                }
                return;
            }
            case 6: {
                if (link != null) {
                    ProcedureOutputManager.blocksDisconnected(event.getSourceWidget(), link.getSocketBlockID(), link.getPlugBlockID());
                }
                return;
            }
            case 3: {
                if (b != null && b.isProcedureDeclBlock()) {
                    myProcInfo.put(b.getBlockID(), new OutputInfo());
                }
                return;
            }
            case 4: {
                if (b != null && b.isProcedureDeclBlock()) {
                    myProcInfo.remove(b.getBlockID());
                    if (link != null) {
                        ProcedureOutputManager.blocksDisconnected(event.getSourceWidget(), link.getSocketBlockID(), link.getPlugBlockID());
                    }
                }
                return;
            }
        }
    }

    public static void finishLoad() {
        for (Block p : workspace.getBlocksFromGenus("procedure")) {
            myProcInfo.put(p.getBlockID(), new OutputInfo());
        }
        for (Block b : workspace.getBlocksFromGenus("return")) {
            OutputInfo info;
            Long top = ProcedureOutputManager.getTopBlockID(b.getBlockID());
            if (top == null || !workspace.getEnv().getBlock(top).isProcedureDeclBlock() || (info = myProcInfo.get(top)).outputs.contains(b)) continue;
            if (info.type == null && !b.getSocketAt(0).getKind().equals("poly")) {
                info.type = b.getSocketAt(0).getKind();
                BlockStub.parentPlugChanged(workspace, top, info.type);
            }
            if (b.getSocketAt(0).getBlockID() != -1L) {
                OutputInfo outputInfo = info;
                outputInfo.numTyped = outputInfo.numTyped + 1;
            }
            info.outputs.add(b.getBlockID());
        }
    }

    public static void reset() {
        myProcInfo.clear();
    }

    private static void blocksConnected(WorkspaceWidget w, Long socket, Long plug) {
        Long top = ProcedureOutputManager.getTopBlockID(socket);
        if (top == null || !workspace.getEnv().getBlock(top).isProcedureDeclBlock()) {
            return;
        }
        OutputInfo info = myProcInfo.get(top);
        ArrayList<WorkspaceEvent> events = new ArrayList<WorkspaceEvent>();
        Block b = workspace.getEnv().getBlock(socket);
        boolean add = true;
        if (ProcedureOutputManager.isOutput(b)) {
            add = false;
        } else {
            b = workspace.getEnv().getBlock(plug);
        }
        if (info.type != null) {
            ProcedureOutputManager.changeType(add, b, info.type, info, w, events);
        } else {
            ProcedureOutputManager.examineType(add, b, info);
            if (info.type != null) {
                ProcedureOutputManager.changeType(info, w, events);
                BlockStub.parentPlugChanged(workspace, top, info.type);
            }
        }
        if (!events.isEmpty()) {
            for (WorkspaceEvent e : events) {
                workspace.notifyListeners(e);
            }
        }
    }

    private static void blocksDisconnected(WorkspaceWidget w, Long socket, Long plug) {
        Long top = ProcedureOutputManager.getTopBlockID(socket);
        if (top == null || !workspace.getEnv().getBlock(top).isProcedureDeclBlock()) {
            return;
        }
        OutputInfo info = myProcInfo.get(top);
        if (ProcedureOutputManager.isOutput(workspace.getEnv().getBlock(socket)) && info.type != null) {
            OutputInfo outputInfo = info;
            outputInfo.numTyped = outputInfo.numTyped - 1;
            workspace.getEnv().getBlock(socket).getSocketAt(0).setKind(info.type);
            workspace.getEnv().getBlock(socket).notifyRenderable();
        } else {
            ProcedureOutputManager.revertType(workspace.getEnv().getBlock(plug), info, true);
        }
        if (info.numTyped == 0) {
            info.type = null;
            ProcedureOutputManager.revertType(workspace.getEnv().getBlock(top), info, false);
            BlockStub.parentPlugChanged(workspace, top, null);
        }
    }

    private static void examineType(boolean add, Block b, OutputInfo info) {
        if (ProcedureOutputManager.isOutput(b)) {
            BlockConnector socket;
            Block b2;
            if (add) {
                info.outputs.add(b.getBlockID());
            }
            if ((b2 = ProcedureOutputManager.getBlock((socket = b.getSocketAt(0)).getBlockID())) != null) {
                OutputInfo outputInfo = info;
                outputInfo.numTyped = outputInfo.numTyped + 1;
                if (info.type == null) {
                    info.type = socket.getKind();
                }
            } else if (!socket.getKind().equals(socket.initKind())) {
                socket.setKind(socket.initKind());
                b.notifyRenderable();
            }
            return;
        }
        for (BlockConnector conn : b.getSockets()) {
            Block b2 = ProcedureOutputManager.getBlock(conn.getBlockID());
            if (b2 == null) continue;
            ProcedureOutputManager.examineType(true, b2, info);
        }
        Block b2 = ProcedureOutputManager.getBlock(b.getAfterBlockID());
        if (b2 != null) {
            ProcedureOutputManager.examineType(true, b2, info);
        }
    }

    private static void changeType(OutputInfo info, WorkspaceWidget w, List<WorkspaceEvent> e) {
        String type = info.type;
        for (Long id : info.outputs) {
            Block b = workspace.getEnv().getBlock(id);
            BlockConnector socket = b.getSocketAt(0);
            Block b2 = ProcedureOutputManager.getBlock(socket.getBlockID());
            if (b2 == null && !socket.getKind().equals(type)) {
                socket.setKind(type);
                b.notifyRenderable();
                continue;
            }
            if (socket.getKind().endsWith(type)) continue;
            BlockLink link = BlockLink.getBlockLink(workspace, b, b2, socket, b2.getPlug());
            link.disconnect();
            workspace.getEnv().getRenderableBlock(id).blockDisconnected(socket);
            e.add(new WorkspaceEvent(workspace, w, link, 6));
        }
    }

    private static void changeType(boolean add, Block b, String type, OutputInfo info, WorkspaceWidget w, List<WorkspaceEvent> e) {
        if (ProcedureOutputManager.isOutput(b)) {
            BlockConnector socket;
            Block b2;
            if (add) {
                info.outputs.add(b.getBlockID());
            }
            if ((b2 = ProcedureOutputManager.getBlock((socket = b.getSocketAt(0)).getBlockID())) == null && !socket.getKind().equals(type)) {
                socket.setKind(type);
                b.notifyRenderable();
            } else if (!socket.getKind().endsWith(type)) {
                OutputInfo outputInfo = info;
                outputInfo.numTyped = outputInfo.numTyped + 1;
                BlockLink link = BlockLink.getBlockLink(workspace, b, b2, socket, b2.getPlug());
                link.disconnect();
                workspace.getEnv().getRenderableBlock(b.getBlockID()).blockDisconnected(socket);
                e.add(new WorkspaceEvent(workspace, w, link, 6));
            } else {
                OutputInfo outputInfo = info;
                outputInfo.numTyped = outputInfo.numTyped + 1;
            }
            return;
        }
        for (BlockConnector conn : b.getSockets()) {
            Block b2 = ProcedureOutputManager.getBlock(conn.getBlockID());
            if (b2 == null) continue;
            ProcedureOutputManager.changeType(true, b2, type, info, w, e);
        }
        Block b2 = ProcedureOutputManager.getBlock(b.getAfterBlockID());
        if (b2 != null) {
            ProcedureOutputManager.changeType(true, b2, type, info, w, e);
        }
    }

    private static void revertType(Block b, OutputInfo info, boolean remove) {
        if (ProcedureOutputManager.isOutput(b)) {
            BlockConnector socket;
            Block b2;
            if (remove) {
                info.outputs.remove(b.getBlockID());
            }
            if ((b2 = ProcedureOutputManager.getBlock((socket = b.getSocketAt(0)).getBlockID())) == null && !socket.getKind().equals(socket.initKind())) {
                socket.setKind(socket.initKind());
                b.notifyRenderable();
            } else if (b2 != null && remove) {
                OutputInfo outputInfo = info;
                outputInfo.numTyped = outputInfo.numTyped - 1;
            }
            return;
        }
        for (BlockConnector conn : b.getSockets()) {
            Block b2 = ProcedureOutputManager.getBlock(conn.getBlockID());
            if (b2 == null) continue;
            ProcedureOutputManager.revertType(b2, info, remove);
        }
        Block b2 = ProcedureOutputManager.getBlock(b.getAfterBlockID());
        if (b2 != null) {
            ProcedureOutputManager.revertType(b2, info, remove);
        }
    }

    public static Block getBlock(Long id) {
        if (id == null || id.equals(Block.NULL)) {
            return null;
        }
        if (workspace != null) {
            return workspace.getEnv().getBlock(id);
        }
        return null;
    }

    private static boolean isOutput(Block b) {
        return ProcedureOutputManager.isCmd("cmd-output", b);
    }

    private static Long getTopBlockID(Long blockID) {
        if (blockID == null || Block.NULL.equals(blockID) || workspace.getEnv().getBlock(blockID) == null) {
            return null;
        }
        Block b = workspace.getEnv().getBlock(blockID);
        if (b.hasBeforeConnector()) {
            return ProcedureOutputManager.getTopBlockID(b.getBeforeBlockID());
        }
        if (b.hasPlug()) {
            return ProcedureOutputManager.getTopBlockID(b.getPlugBlockID());
        }
        if (b.isProcedureDeclBlock()) {
            return blockID;
        }
        return ProcedureOutputManager.isForeverRunBlock(blockID) ? blockID : null;
    }

    public static boolean isForeverRunBlock(Long blockID) {
        if (blockID.equals(Block.NULL)) {
            return false;
        }
        RuntimeType rt = ProcedureOutputManager.getRuntimeType(workspace.getEnv().getBlock(blockID));
        return rt == RuntimeType.FOREVER || rt == RuntimeType.RUNFORSOMETIME || rt == RuntimeType.RUNONCE || rt == RuntimeType.LOOP;
    }

    private static RuntimeType getRuntimeType(Block b) {
        return RuntimeType.getRuntime(b.getProperty(RUNTIME_TYPE));
    }

    public static boolean isCmd(String cmd, Block b) {
        return b != null && cmd.equals(b.getProperty(VM_COMMAND_NAME));
    }

    private static class OutputInfo {
        private final List<Long> outputs = new ArrayList<Long>(5);
        private String type = null;
        private int numTyped = 0;

        private OutputInfo() {
        }
    }

    public static enum RuntimeType {
        FOREVER("forever"),
        RUNONCE("runonce"),
        RUNFORSOMETIME("runforsometime"),
        LOOP("loop"),
        NULL_RUNTIME("");

        private final String myString;

        private RuntimeType(String s) {
            this.myString = s;
        }

        public String getString() {
            return this.myString;
        }

        public static RuntimeType getRuntime(String s) {
            RuntimeType[] runtimeTypeArray = RuntimeType.values();
            int n = runtimeTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                RuntimeType t = runtimeTypeArray[n2];
                if (t.myString.equals(s)) {
                    return t;
                }
                ++n2;
            }
            return NULL_RUNTIME;
        }
    }
}

