/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.blocks.workspace;

import edu.mit.blocks.codeblocks.Block;
import edu.mit.blocks.codeblocks.ProcedureOutputManager;
import edu.mit.blocks.codeblockutil.Explorer;
import edu.mit.blocks.codeblockutil.ExplorerEvent;
import edu.mit.blocks.codeblockutil.ExplorerListener;
import edu.mit.blocks.renderable.BlockUtilities;
import edu.mit.blocks.renderable.RenderableBlock;
import edu.mit.blocks.workspace.BlockCanvas;
import edu.mit.blocks.workspace.FactoryManager;
import edu.mit.blocks.workspace.ISupportMemento;
import edu.mit.blocks.workspace.MiniMap;
import edu.mit.blocks.workspace.Page;
import edu.mit.blocks.workspace.PageDrawerLoadingUtils;
import edu.mit.blocks.workspace.RBParent;
import edu.mit.blocks.workspace.SearchableContainer;
import edu.mit.blocks.workspace.Subset;
import edu.mit.blocks.workspace.WorkspaceEnvironment;
import edu.mit.blocks.workspace.WorkspaceEvent;
import edu.mit.blocks.workspace.WorkspaceListener;
import edu.mit.blocks.workspace.WorkspaceWidget;
import edu.mit.blocks.workspace.typeblocking.FocusTraversalManager;
import edu.mit.blocks.workspace.typeblocking.TypeBlockManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Workspace
extends JLayeredPane
implements ISupportMemento,
RBParent,
ChangeListener,
ExplorerListener {
    private static final long serialVersionUID = 328149080422L;
    private final WorkspaceEnvironment env = new WorkspaceEnvironment();
    private HashSet<WorkspaceListener> workspaceListeners = new HashSet();
    private TreeSet<WorkspaceWidget> workspaceWidgets = new TreeSet<WorkspaceWidget>(new Comparator<WorkspaceWidget>(){

        @Override
        public int compare(WorkspaceWidget w1, WorkspaceWidget w2) {
            double depth2;
            double depth1 = Workspace.this.getDrawDepth(w1.getJComponent());
            if (depth1 > (depth2 = Workspace.this.getDrawDepth(w2.getJComponent()))) {
                return 1;
            }
            if (depth1 < depth2) {
                return -1;
            }
            if (w1 != w2) {
                return -1;
            }
            return 0;
        }
    });
    public static boolean everyPageHasDrawer = false;
    private BlockCanvas blockCanvas = new BlockCanvas(this);
    private JSplitPane blockCanvasLayer;
    private MiniMap miniMap;
    private FactoryManager factory;
    private final FocusTraversalManager focusManager;
    private final TypeBlockManager typeBlockManager;
    public static final Integer PAGE_LAYER = new Integer(0);
    public static final Integer BLOCK_HIGHLIGHT_LAYER = new Integer(1);
    public static final Integer BLOCK_LAYER = new Integer(2);
    public static final Integer WIDGET_LAYER = new Integer(3);
    public static final Integer DRAGGED_BLOCK_HIGHLIGHT_LAYER = new Integer(4);
    public static final Integer DRAGGED_BLOCK_LAYER = new Integer(5);
    private Point p = new Point(0, 0);
    private double zoom = 1.0;

    public WorkspaceEnvironment getEnv() {
        return this.env;
    }

    public Workspace() {
        this.setLayout(null);
        this.setBackground(Color.WHITE);
        this.setPreferredSize(new Dimension(800, 600));
        this.factory = new FactoryManager(this);
        this.addWorkspaceListener(this.factory);
        this.blockCanvas.getHorizontalModel().addChangeListener(this);
        for (Explorer exp : this.factory.getNavigator().getExplorers()) {
            exp.addListener(this);
        }
        this.miniMap = new MiniMap(this);
        this.addWidget(this.miniMap, true, true);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                Workspace.this.miniMap.repositionMiniMap();
                Workspace.this.blockCanvas.reformBlockCanvas();
                Workspace.this.blockCanvasLayer.setSize(Workspace.this.getSize());
                Workspace.this.blockCanvasLayer.validate();
            }
        });
        this.blockCanvasLayer = new JSplitPane(1, true, this.factory.getJComponent(), this.blockCanvas.getJComponent());
        this.blockCanvasLayer.setOneTouchExpandable(true);
        this.blockCanvasLayer.setDividerSize(6);
        this.add((Component)this.blockCanvasLayer, BLOCK_LAYER);
        this.validate();
        this.addPageAt(Page.getBlankPage(this), 0, false);
        this.workspaceWidgets.add(this.factory);
        this.focusManager = new FocusTraversalManager(this);
        this.typeBlockManager = new TypeBlockManager(this, this.blockCanvas);
    }

    @Override
    public void explorerEventOccurred(ExplorerEvent event) {
        block3: {
            Explorer exp;
            block2: {
                exp = event.getSource();
                if (event.getEventType() != 1) break block2;
                for (Page p : this.blockCanvas.getLeftmostPages(exp.getSelectedCanvasWidth())) {
                    p.disableMinimize();
                }
                break block3;
            }
            if (event.getEventType() != 2) break block3;
            for (Page p : this.blockCanvas.getLeftmostPages(exp.getSelectedCanvasWidth())) {
                p.enableMinimize();
            }
        }
    }

    public Dimension getCanvasSize() {
        return this.blockCanvas.getCanvas().getSize();
    }

    public Dimension getCanvasOffset() {
        return new Dimension(this.blockCanvas.getHorizontalModel().getValue() - this.blockCanvas.getJComponent().getX(), this.blockCanvas.getVerticalModel().getValue() - this.blockCanvas.getJComponent().getY());
    }

    public Page getPageNamed(String pageName) {
        return this.blockCanvas.getPageNamed(pageName);
    }

    public BlockCanvas getBlockCanvas() {
        return this.blockCanvas;
    }

    public MiniMap getMiniMap() {
        return this.miniMap;
    }

    public FocusTraversalManager getFocusManager() {
        return this.focusManager;
    }

    public void disableMiniMap() {
        this.miniMap.hideMiniMap();
    }

    public WorkspaceWidget getWidgetAt(Point point) {
        Iterator<WorkspaceWidget> it = this.workspaceWidgets.iterator();
        if (this.factory.contains(SwingUtilities.convertPoint((Component)this, (Point)point, (Component)this.factory.getJComponent()).x, SwingUtilities.convertPoint((Component)this, (Point)point, (Component)this.factory.getJComponent()).y)) {
            return this.factory;
        }
        WorkspaceWidget widget = null;
        while (it.hasNext()) {
            widget = it.next();
            this.p = SwingUtilities.convertPoint(this, point, widget.getJComponent());
            if (!widget.contains(this.p.x, this.p.y) || !widget.getJComponent().isVisible()) continue;
            return widget;
        }
        return null;
    }

    private double getDrawDepth(Component c) {
        int treeLevel = 0;
        double depth = 0.0;
        Container p = c.getParent();
        if (p != null) {
            while (p != this && p != null) {
                p = p.getParent();
                ++treeLevel;
            }
            p = c.getParent();
            int level = treeLevel;
            while (level >= 0) {
                if (p == null) break;
                depth = level > 0 ? (depth -= (double)p.getComponentZOrder(c) / Math.pow(10.0, level)) : (depth += (double)p.getComponentZOrder(c));
                c = p;
                p = p.getParent();
                --level;
            }
            return depth;
        }
        return Double.MAX_VALUE;
    }

    public void addWidget(WorkspaceWidget widget, boolean addGraphically, boolean floatOverCanvas) {
        boolean success;
        if (addGraphically) {
            if (floatOverCanvas) {
                this.add((Component)((JComponent)((Object)widget)), WIDGET_LAYER);
                widget.getJComponent().setVisible(true);
                this.revalidate();
                this.repaint();
            } else {
                this.blockCanvas.getJComponent().setPreferredSize(new Dimension(this.blockCanvas.getWidth() - widget.getJComponent().getWidth(), this.blockCanvasLayer.getHeight()));
            }
        }
        if (!(success = this.workspaceWidgets.add(widget))) {
            System.err.println("not able to add: " + widget);
        }
    }

    public void removeWidget(WorkspaceWidget widget) {
        this.workspaceWidgets.remove(widget);
        this.remove((JComponent)((Object)widget));
    }

    public Iterable<WorkspaceWidget> getWorkspaceWidgets() {
        return Collections.unmodifiableSet(this.workspaceWidgets);
    }

    public Iterable<RenderableBlock> getRenderableBlocks() {
        return this.blockCanvas.getBlocks();
    }

    public Iterable<Block> getBlocks() {
        ArrayList<Block> blocks = new ArrayList<Block>();
        for (RenderableBlock renderable : this.blockCanvas.getBlocks()) {
            blocks.add(this.getEnv().getBlock(renderable.getBlockID()));
        }
        return blocks;
    }

    public Iterable<RenderableBlock> getRenderableBlocksFromGenus(String genusName) {
        ArrayList<RenderableBlock> blocks = new ArrayList<RenderableBlock>();
        for (RenderableBlock block : this.blockCanvas.getBlocks()) {
            if (!this.getEnv().getBlock(block.getBlockID()).getGenusName().equals(genusName)) continue;
            blocks.add(block);
        }
        return blocks;
    }

    public Iterable<Block> getBlocksFromGenus(String genusName) {
        ArrayList<Block> blocks = new ArrayList<Block>();
        for (RenderableBlock renderable : this.blockCanvas.getBlocks()) {
            Block block = this.getEnv().getBlock(renderable.getBlockID());
            if (!block.getGenusName().equals(genusName)) continue;
            blocks.add(block);
        }
        return blocks;
    }

    public Iterable<RenderableBlock> getTopLevelBlocks() {
        return this.blockCanvas.getTopLevelBlocks();
    }

    public void cleanUpAllBlocks() {
        this.blockCanvas.arrangeAllBlocks();
    }

    public void copyBlocks() {
        TypeBlockManager.copyBlock(this);
    }

    public void pasteBlocks() {
        TypeBlockManager.pasteBlock(this);
    }

    public void addWorkspaceListener(WorkspaceListener listener) {
        if (listener != null) {
            assert (!this.workspaceListeners.contains(listener)) : "WorkspaceListener " + listener.toString() + " has already been added.";
            this.workspaceListeners.add(listener);
        }
    }

    public void removeWorkspaceListener(WorkspaceListener listener) {
        if (listener != null) {
            this.workspaceListeners.remove(listener);
        }
    }

    public void notifyListeners(WorkspaceEvent event) {
        for (WorkspaceListener wl : this.workspaceListeners) {
            wl.workspaceEventOccurred(event);
        }
    }

    public void enableTypeBlocking(boolean enabled) {
        this.typeBlockManager.setEnabled(enabled);
    }

    public TypeBlockManager getTypeBlockManager() {
        return this.typeBlockManager;
    }

    public void setWorkspaceZoom(double newZoom) {
        double oldZoom = this.zoom;
        int cDX = 0;
        int cDY = 0;
        this.zoom = newZoom;
        BlockUtilities.setZoomLevel(newZoom);
        for (RenderableBlock block : this.getRenderableBlocks()) {
            block.setZoomLevel(newZoom);
        }
        for (RenderableBlock block : this.getFactoryManager().getBlocks()) {
            block.setZoomLevel(newZoom);
        }
        for (Page p : this.getBlockCanvas().getPages()) {
            for (RenderableBlock block : p.getTopLevelBlocks()) {
                if (block.getUnzoomedX() == 0.0 && block.getUnzoomedY() == 0.0) {
                    if (newZoom == 1.0) {
                        block.setUnzoomedX(block.getX());
                        block.setUnzoomedY(block.getY());
                    } else {
                        block.setUnzoomedX(block.calculateUnzoomedX(block.getX()));
                        block.setUnzoomedY(block.calculateUnzoomedY(block.getY()));
                    }
                }
                if (block.hasComment()) {
                    cDX = (int)((double)(block.getComment().getX() - block.getX()) / oldZoom * newZoom);
                    cDY = (int)((double)(block.getComment().getY() - block.getY()) / oldZoom * newZoom);
                }
                block.setLocation((int)(block.getUnzoomedX() * this.zoom), (int)(block.getUnzoomedY() * this.zoom));
                if (block.hasComment()) {
                    block.getComment().setLocation(block.getX() + cDX, block.getY() + cDY);
                }
                block.redrawFromTop();
                block.repaint();
            }
        }
        Page.setZoomLevel(newZoom);
    }

    public double getCurrentWorkspaceZoom() {
        return this.zoom;
    }

    public void setWorkspaceZoomToDefault() {
        this.setWorkspaceZoom(1.0);
    }

    public void scrollToComponent(JComponent c) {
        this.blockCanvas.scrollToComponent(c);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        List<Explorer> explorers = this.factory.getNavigator().getExplorers();
        for (Explorer exp : explorers) {
            List<Page> leftMostPages = this.blockCanvas.getLeftmostPages(exp.getSelectedCanvasWidth());
            boolean expanded = exp.anyCanvasSelected();
            for (Page p : this.blockCanvas.getPages()) {
                if (!expanded) continue;
                p.setHide(false);
            }
            for (Page p : leftMostPages) {
                if (!expanded) continue;
                p.setHide(true);
            }
        }
    }

    public void addPage(Page page) {
        this.addPage(page, this.blockCanvas.numOfPages());
    }

    public void addPage(Page page, int position) {
        this.addPageAt(page, position, true);
    }

    public void putPage(Page page, int position) {
        if (this.blockCanvas.hasPageAt(position)) {
            this.removePageAt(position);
        }
        this.addPageAt(page, this.blockCanvas.numOfPages(), true);
    }

    private void addPageAt(Page page, int index, boolean fireWorkspaceEvent) {
        this.blockCanvas.addPage(page, index);
        this.workspaceWidgets.add(page);
        if (fireWorkspaceEvent) {
            this.notifyListeners(new WorkspaceEvent(this, page, 1));
        }
    }

    public void removePageAt(int position) {
        this.removePage(this.blockCanvas.getPageAt(position));
    }

    public void removePage(Page page) {
        boolean success = this.workspaceWidgets.remove(page);
        if (!success) {
            System.out.println("Page: " + page + ", was NOT removed successfully");
        }
        this.notifyListeners(new WorkspaceEvent(this, page, 2));
        this.blockCanvas.removePage(page);
    }

    public void renamePage(String oldName, String newName) {
        Page renamedPage = this.blockCanvas.renamePage(oldName, newName);
        this.factory.renameDynamicDrawer(oldName, newName);
        this.notifyListeners(new WorkspaceEvent(this, (WorkspaceWidget)renamedPage, oldName, 8));
    }

    public int getNumPages() {
        return this.blockCanvas.numOfPages();
    }

    public Page getCurrentPage(RenderableBlock block) {
        for (Page page : this.getBlockCanvas().getPages()) {
            if (!page.contains(SwingUtilities.convertPoint(block.getParent(), block.getLocation(), page.getJComponent()))) continue;
            return page;
        }
        return null;
    }

    public void pageSelected(Page page, boolean byUser) {
        this.blockCanvas.switchViewToPage(page);
    }

    public FactoryManager getFactoryManager() {
        return this.factory;
    }

    public Iterable<SearchableContainer> getAllSearchableContainers() {
        ArrayList<SearchableContainer> containers = new ArrayList<SearchableContainer>(this.factory.getSearchableContainers());
        for (WorkspaceWidget w : this.workspaceWidgets) {
            if (!(w instanceof SearchableContainer)) continue;
            containers.add((SearchableContainer)((Object)w));
        }
        return Collections.unmodifiableList(containers);
    }

    public void setupSubsets(Collection<Subset> subsets, boolean usingSys, boolean usingSubs) {
        this.factory.setupSubsets(subsets, usingSys, usingSubs);
    }

    public Node getSaveNode(Document document) {
        return this.blockCanvas.getSaveNode(document);
    }

    private void setMaxBlockId(Element newRoot, Element originalLangRoot) {
        XPathFactory factory = XPathFactory.newInstance();
        XPath xpath = factory.newXPath();
        long maxId = 1L;
        try {
            long myId;
            Attr attr;
            int i;
            NodeList bgs;
            XPathExpression expr = xpath.compile("//@id");
            if (newRoot != null) {
                bgs = (NodeList)expr.evaluate(newRoot, XPathConstants.NODESET);
                i = 0;
                while (i < bgs.getLength()) {
                    attr = (Attr)bgs.item(i);
                    myId = Long.parseLong(attr.getValue());
                    maxId = myId > maxId ? myId : maxId;
                    ++i;
                }
            }
            if (originalLangRoot != null) {
                bgs = (NodeList)expr.evaluate(originalLangRoot, XPathConstants.NODESET);
                i = 0;
                while (i < bgs.getLength()) {
                    attr = (Attr)bgs.item(i);
                    myId = Long.parseLong(attr.getValue());
                    maxId = myId > maxId ? myId : maxId;
                    ++i;
                }
            }
            this.env.setNextBlockID(maxId + 1L);
        }
        catch (XPathExpressionException e) {
            e.printStackTrace();
        }
    }

    public void loadWorkspaceFrom(Element newRoot, Element originalLangRoot) {
        this.setMaxBlockId(newRoot, originalLangRoot);
        ProcedureOutputManager.finishLoad();
        if (newRoot != null) {
            PageDrawerLoadingUtils.loadBlockDrawerSets(this, originalLangRoot, this.factory);
            this.blockCanvas.loadSaveString(newRoot);
            PageDrawerLoadingUtils.loadBlockDrawerSets(this, newRoot, this.factory);
            this.loadWorkspaceSettings(newRoot);
        } else {
            this.blockCanvas.loadSaveString(originalLangRoot);
            PageDrawerLoadingUtils.loadBlockDrawerSets(this, originalLangRoot, this.factory);
            this.loadWorkspaceSettings(originalLangRoot);
        }
    }

    private void loadWorkspaceSettings(Element root) {
        Matcher nameMatcher;
        Pattern attrExtractor = Pattern.compile("\"(.*)\"");
        NodeList miniMapNodes = root.getElementsByTagName("MiniMap");
        int i = 0;
        while (i < miniMapNodes.getLength()) {
            Node miniMapNode = miniMapNodes.item(i);
            if (miniMapNode.getNodeName().equals("MiniMap") && (nameMatcher = attrExtractor.matcher(miniMapNode.getAttributes().getNamedItem("enabled").toString())).find() && nameMatcher.group(1).equals("no")) {
                this.disableMiniMap();
            }
            ++i;
        }
        NodeList typeNodes = root.getElementsByTagName("Typeblocking");
        int i2 = 0;
        while (i2 < typeNodes.getLength()) {
            Node typeNode = typeNodes.item(i2);
            if (typeNode.getNodeName().equals("Typeblocking")) {
                nameMatcher = attrExtractor.matcher(typeNode.getAttributes().getNamedItem("enabled").toString());
                if (nameMatcher.find() && nameMatcher.group(1).equals("no")) {
                    this.enableTypeBlocking(false);
                } else {
                    this.enableTypeBlocking(true);
                }
            }
            ++i2;
        }
    }

    public void reset() {
        ArrayList<WorkspaceWidget> widgetsToRemove = new ArrayList<WorkspaceWidget>();
        ArrayList<WorkspaceWidget> widgetsToKeep = new ArrayList<WorkspaceWidget>();
        for (WorkspaceWidget w : this.workspaceWidgets) {
            if (w instanceof Page) {
                widgetsToRemove.add(w);
                continue;
            }
            widgetsToKeep.add(w);
        }
        this.workspaceWidgets.clear();
        this.workspaceWidgets.addAll(widgetsToKeep);
        this.workspaceWidgets.add(this.factory);
        for (WorkspaceWidget w : widgetsToRemove) {
            Container parent = w.getJComponent().getParent();
            if (w instanceof Page) {
                ((Page)w).reset();
            }
            if (parent == null) continue;
            parent.remove(w.getJComponent());
            parent.validate();
            parent.repaint();
        }
        this.blockCanvas.reset();
        this.addPageAt(Page.getBlankPage(this), 0, false);
        this.factory.reset();
        this.env.resetAll();
        this.revalidate();
    }

    @Override
    public Object getState() {
        return null;
    }

    @Override
    public void loadState(Object memento) {
        assert (memento instanceof WorkspaceState) : "";
        if (memento instanceof WorkspaceState) {
            WorkspaceState state = (WorkspaceState)memento;
            for (Long blockID : state.blockStates.keySet()) {
                Block toBeUpdated = this.getEnv().getBlock(blockID);
                toBeUpdated.loadState(state.blockStates.get(blockID));
            }
            this.blockCanvas.loadState(state.blockCanvasState);
        }
    }

    public void undo() {
    }

    public void redo() {
    }

    @Override
    public void addToBlockLayer(Component c) {
        this.add(c, DRAGGED_BLOCK_LAYER);
    }

    @Override
    public void addToHighlightLayer(Component c) {
        this.add(c, DRAGGED_BLOCK_HIGHLIGHT_LAYER);
    }

    private class WorkspaceState {
        public Map<Long, Object> blockStates;
        public Object blockCanvasState;

        private WorkspaceState() {
        }
    }
}

