// --- Programme Arduino ---
// par X. HINAULT - Le 10/03/2010
// www.mon-club-elec.fr 

// --- Que fait ce programme ? ---
/* teste moteur pas à pas bipolaire connecté via interface sur 4 broches*/

// --- Fonctionnalités utilisées ---
// Utilise un ou plusieurs moteurs pas à pas 

// --- Circuit à réaliser ---
// Connecter  sur la broche 4 (configurée en sortie)  la broche de commande du pas 1 du moteur pas à pas
// Connecter  sur la broche 5 (configurée en sortie)  la broche de commande du pas 2 du moteur pas à pas
// Connecter  sur la broche 6 (configurée en sortie)  la broche de commande du pas 3 du moteur pas à pas
// Connecter  sur la broche 7 (configurée en sortie)  la broche de commande du pas 4 du moteur pas à pas

//**************** Entête déclarative *******
// A ce niveau sont déclarées les librairies, les constantes, les variables...

// --- Inclusion des librairies utilisées ---

#include <Stepper.h> // librairie pour moteurs pas à pas

// --- Déclaration des constantes ---
const int NombrePas= 32*64; // Nombre de pas du servomoteur pour un tour de roue
const int Vitesse = 9; // 10 maxi
const int Tourne = 810;// nombre de pas pour tourner de 90° en fonction du diametre de la roue

// --- constantes des broches ---

const int PasG_1=4; //declaration constante de broche 
const int PasG_2=5; //declaration constante de broche 
const int PasG_3=6; //declaration constante de broche 
const int PasG_4=7; //declaration constante de broche 

const int PasD_1=8; //declaration constante de broche 
const int PasD_2=9; //declaration constante de broche 
const int PasD_3=10; //declaration constante de broche 
const int PasD_4=11; //declaration constante de broche 


// --- Déclaration des variables globales ---

// --- Déclaration des objets utiles pour les fonctionnalités utilisées ---
Stepper roueD(NombrePas, PasD_1, PasD_3, PasD_2, PasD_4);  //moteur droit
// crée un objet Stepper pour contrôler le moteur pas à pas
// Pas_1 et Pas_3 commandent la 1ère phase, Pas_2 et Pas_4 la 2ème phase 
Stepper roueG(NombrePas, PasG_1, PasG_3, PasG_2, PasG_4);  //moteur gauche


//**************** FONCTION SETUP = Code d'initialisation *****
// La fonction setup() est exécutée en premier et 1 seule fois, au démarrage du programme

void setup()   { // debut de la fonction setup()

// --- ici instructions à exécuter au démarrage --- 

// initialise la vitesse de rotation du moteur pas à pas en tour par minute
roueD.setSpeed(Vitesse); 
roueG.setSpeed(Vitesse); 

// ------- Broches en sortie -------  

pinMode(PasD_1, OUTPUT); //met la broche en sortie 
pinMode(PasD_2, OUTPUT); //met la broche en sortie 
pinMode(PasD_3, OUTPUT); //met la broche en sortie 
pinMode(PasD_4, OUTPUT); //met la broche en sortie 

pinMode(PasG_1, OUTPUT); //met la broche en sortie 
pinMode(PasG_2, OUTPUT); //met la broche en sortie 
pinMode(PasG_3, OUTPUT); //met la broche en sortie 
pinMode(PasG_4, OUTPUT); //met la broche en sortie 

// ------- Broches en entrée -------  


// ------- Activation du rappel au + interne des broches en entrée si nécessaire -------  


} // fin de la fonction setup()
// ********************************************************************************

//*************** FONCTION LOOP = Boucle sans fin = coeur du programme *************
// la fonction loop() s'exécute sans fin en boucle aussi longtemps que l'Arduino est sous tension


int avance(int NPas) // 1 tour de roue
{

for (int i=1; i<=NPas; i++){ // boucle de défilement du nombre de pas
  roueD.step(1); // un pas en sens positif
  roueG.step(1);
}

}



int recule(int NPas) // 1 tour de roue
{

for (int i=1; i<=NPas; i++){ // boucle de défilement du nombre de pas
  roueD.step(-1);
  roueG.step(-1);
}

}

void droite()
{
 for (int i=1; i<= Tourne; i++)
  { 
    roueG.step(1);
    roueD.step(-1);
    
  } 
}

void gauche()
{
 for (int i=1; i<= Tourne; i++)
  { 
    roueG.step(-1);
    roueD.step(1);
    
  } 
}


void loop()
{ 
for ( int i = 0; i< 4; i++) // carre tourne droite
  {  
    avance(NombrePas);
    delay(1000);
    droite();
    delay(1000);
  }
for ( int i= 0 ; i< 4; i++)// carre tourne gauche
  {
    avance(NombrePas);
    delay(1000);
    gauche();
    delay(1000);
  }  



avance(NombrePas);
delay(1000);
recule(NombrePas);
delay(1000);

}

  


