/*
 * MotorKnob
 *
 * A stepper motor follows the turns of a potentiometer
 * (or other sensor) on analog input 0.
 *
 * http://www.arduino.cc/en/Reference/Stepper
 * This example code is in the public domain.
 */

#include <Stepper.h>

// change this to the number of steps on your motor
#define STEPS 32*64

// create an instance of the stepper class, specifying
// the number of steps of the motor and the pins it's
// attached to
Stepper stepper(STEPS, 8, 10, 9, 11);

// the previous reading from the analog input
int valActuel;
int valPreced;

void setup() {
  // set the speed of the motor to 30 RPMs
  stepper.setSpeed(9);
  Serial.begin(9600);
}

void loop() {
 valActuel = map((analogRead(A0)),0,1023,0,2048);
 stepper.step(valActuel- valPreced);
 valPreced = valActuel;
}
