/*
 * Decompiled with CFR 0.152.
 */
package cc.arduino.contributions.libraries.ui;

import cc.arduino.contributions.DownloadableContributionBuiltInAtTheBottomComparator;
import cc.arduino.contributions.filters.InstalledPredicate;
import cc.arduino.contributions.libraries.ContributedLibrary;
import cc.arduino.contributions.ui.FilteredAbstractTableModel;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;

public class ContributedLibraryReleases {
    private final ContributedLibrary library;
    private final List<ContributedLibrary> releases;
    private final List<String> versions;
    private ContributedLibrary selected;

    public ContributedLibraryReleases(ContributedLibrary library) {
        this.library = library;
        this.versions = new LinkedList<String>();
        this.releases = new LinkedList<ContributedLibrary>();
        this.selected = null;
        this.add(library);
    }

    public ContributedLibrary getLibrary() {
        return this.library;
    }

    public List<ContributedLibrary> getReleases() {
        return this.releases;
    }

    public boolean shouldContain(ContributedLibrary lib) {
        return lib.getName().equals(this.library.getName());
    }

    public void add(ContributedLibrary library) {
        this.releases.add(library);
        String version = library.getParsedVersion();
        if (version != null) {
            this.versions.add(version);
        }
        this.selected = this.getLatest();
    }

    public ContributedLibrary getInstalled() {
        List installedReleases = this.releases.stream().filter(new InstalledPredicate()).collect(Collectors.toList());
        Collections.sort(installedReleases, new DownloadableContributionBuiltInAtTheBottomComparator());
        if (installedReleases.isEmpty()) {
            return null;
        }
        return (ContributedLibrary)installedReleases.get(0);
    }

    public ContributedLibrary getLatest() {
        return FilteredAbstractTableModel.getLatestOf(this.releases);
    }

    public ContributedLibrary getSelected() {
        return this.selected;
    }

    public void select(ContributedLibrary value) {
        for (ContributedLibrary plat : this.releases) {
            if (plat != value) continue;
            this.selected = plat;
            return;
        }
    }
}

