/*
 * Decompiled with CFR 0.152.
 */
package cc.arduino.contributions.packages.ui;

import cc.arduino.contributions.DownloadableContributionBuiltInAtTheBottomComparator;
import cc.arduino.contributions.filters.InstalledPredicate;
import cc.arduino.contributions.packages.ContributedPackage;
import cc.arduino.contributions.packages.ContributedPlatform;
import cc.arduino.contributions.packages.ui.ContributionIndexTableModel;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;

public class ContributedPlatformReleases {
    public final ContributedPackage packager;
    public final String arch;
    public final List<ContributedPlatform> releases;
    public final List<String> versions;
    public ContributedPlatform selected = null;

    public ContributedPlatformReleases(ContributedPlatform platform) {
        this.packager = platform.getParentPackage();
        this.arch = platform.getArchitecture();
        this.releases = new LinkedList<ContributedPlatform>();
        this.versions = new LinkedList<String>();
        this.add(platform);
    }

    public boolean shouldContain(ContributedPlatform platform) {
        if (platform.getParentPackage() != this.packager) {
            return false;
        }
        return platform.getArchitecture().equals(this.arch);
    }

    public void add(ContributedPlatform platform) {
        this.releases.add(platform);
        String version = platform.getParsedVersion();
        if (version != null) {
            this.versions.add(version);
        }
        this.selected = this.getLatest();
    }

    public ContributedPlatform getInstalled() {
        List installedReleases = this.releases.stream().filter(new InstalledPredicate()).collect(Collectors.toList());
        Collections.sort(installedReleases, new DownloadableContributionBuiltInAtTheBottomComparator());
        if (installedReleases.isEmpty()) {
            return null;
        }
        return (ContributedPlatform)installedReleases.get(0);
    }

    public ContributedPlatform getLatest() {
        return ContributionIndexTableModel.getLatestOf(this.releases);
    }

    public ContributedPlatform getSelected() {
        return this.selected;
    }

    public void select(ContributedPlatform value) {
        for (ContributedPlatform plat : this.releases) {
            if (plat != value) continue;
            this.selected = plat;
            return;
        }
    }
}

