/*
 * Decompiled with CFR 0.152.
 */
package com.ardublock.translator;

import com.ardublock.translator.adaptor.BlockAdaptor;
import com.ardublock.translator.adaptor.OpenBlocksAdaptor;
import com.ardublock.translator.block.TranslatorBlock;
import com.ardublock.translator.block.TranslatorBlockFactory;
import com.ardublock.translator.block.exception.BlockException;
import com.ardublock.translator.block.exception.SocketNullException;
import com.ardublock.translator.block.exception.SubroutineNameDuplicatedException;
import com.ardublock.translator.block.exception.SubroutineNotDeclaredException;
import edu.mit.blocks.codeblocks.Block;
import edu.mit.blocks.renderable.RenderableBlock;
import edu.mit.blocks.workspace.Workspace;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Translator {
    private static final String variablePrefix = "_ABVAR_";
    private Set<String> headerFileSet;
    private Set<String> definitionSet;
    private List<String> setupCommand;
    private List<String> guinoCommand;
    private Set<String> functionNameSet;
    private Set<String> functionNameSetReturnInt;
    private Set<String> functionNameSetReturnBoolean;
    private Set<TranslatorBlock> bodyTranslatreFinishCallbackSet;
    private BlockAdaptor blockAdaptor;
    private Set<String> inputPinSet;
    private Set<String> outputPinSet;
    private Map<String, String> numberVariableSet;
    private Map<String, String> booleanVariableSet;
    private Map<String, String> stringVariableSet;
    private Map<String, Object> internalData;
    private Workspace workspace;
    private String rootBlockName;
    private int variableCnt;
    private boolean isScoopProgram;
    private boolean isGuinoProgram;
    private boolean isVirtuinoProgram;

    public Translator(Workspace ws) {
        this.workspace = ws;
        this.reset();
    }

    public String genreateHeaderCommand() {
        StringBuilder headerCommand = new StringBuilder();
        if (!this.headerFileSet.isEmpty()) {
            for (String file : this.headerFileSet) {
                headerCommand.append("#include <" + file + ">\n");
            }
            headerCommand.append("\n");
        }
        if (!this.definitionSet.isEmpty()) {
            for (String command : this.definitionSet) {
                headerCommand.append(String.valueOf(command) + "\n");
            }
            headerCommand.append("\n");
        }
        return String.valueOf(headerCommand.toString()) + this.generateSetupFunction() + this.generateGuinoFunction();
    }

    public String generateSetupFunction() {
        StringBuilder setupFunction = new StringBuilder();
        setupFunction.append("void setup()\n{\n");
        if (!this.inputPinSet.isEmpty()) {
            for (String pinNumber : this.inputPinSet) {
                setupFunction.append("pinMode( " + pinNumber + " , INPUT);\n");
            }
        }
        if (!this.outputPinSet.isEmpty()) {
            for (String pinNumber : this.outputPinSet) {
                setupFunction.append("pinMode( " + pinNumber + " , OUTPUT);\n");
            }
        }
        if (!this.setupCommand.isEmpty()) {
            for (String command : this.setupCommand) {
                setupFunction.append(String.valueOf(command) + "\n");
            }
        }
        setupFunction.append("}\n\n");
        return setupFunction.toString();
    }

    public String generateGuinoFunction() {
        StringBuilder guinoFunction = new StringBuilder();
        if (!this.guinoCommand.isEmpty()) {
            guinoFunction.append("void GUINO_DEFINIR_INTERFACE()\n{\n");
            for (String command : this.guinoCommand) {
                guinoFunction.append(String.valueOf(command) + "\n");
            }
            guinoFunction.append("}\n\n");
        }
        return guinoFunction.toString();
    }

    public String translate(Long blockId) throws SocketNullException, SubroutineNotDeclaredException, BlockException {
        TranslatorBlockFactory translatorBlockFactory = new TranslatorBlockFactory();
        Block block = this.workspace.getEnv().getBlock(blockId);
        TranslatorBlock rootTranslatorBlock = translatorBlockFactory.buildTranslatorBlock(this, blockId, block.getGenusName(), "", "", block.getBlockLabel());
        return rootTranslatorBlock.toCode();
    }

    public BlockAdaptor getBlockAdaptor() {
        return this.blockAdaptor;
    }

    public void reset() {
        this.headerFileSet = new LinkedHashSet<String>();
        this.definitionSet = new LinkedHashSet<String>();
        this.setupCommand = new LinkedList<String>();
        this.guinoCommand = new LinkedList<String>();
        this.functionNameSet = new HashSet<String>();
        this.functionNameSetReturnInt = new HashSet<String>();
        this.functionNameSetReturnBoolean = new HashSet<String>();
        this.inputPinSet = new HashSet<String>();
        this.outputPinSet = new HashSet<String>();
        this.bodyTranslatreFinishCallbackSet = new HashSet<TranslatorBlock>();
        this.numberVariableSet = new HashMap<String, String>();
        this.booleanVariableSet = new HashMap<String, String>();
        this.stringVariableSet = new HashMap<String, String>();
        this.internalData = new HashMap<String, Object>();
        this.blockAdaptor = this.buildOpenBlocksAdaptor();
        this.variableCnt = 0;
        this.rootBlockName = null;
        this.isScoopProgram = false;
        this.isGuinoProgram = false;
        this.isVirtuinoProgram = false;
    }

    private BlockAdaptor buildOpenBlocksAdaptor() {
        return new OpenBlocksAdaptor();
    }

    public void addHeaderFile(String headerFile) {
        if (!this.headerFileSet.contains(headerFile)) {
            this.headerFileSet.add(headerFile);
        }
    }

    public void addSetupCommand(String command) {
        if (!this.setupCommand.contains(command)) {
            this.setupCommand.add(command);
        }
    }

    public void addSetupCommandForced(String command) {
        this.setupCommand.add(command);
    }

    public void addGuinoCommand(String command) {
        this.guinoCommand.add(command);
    }

    public void addDefinitionCommand(String command) {
        this.definitionSet.add(command);
    }

    public void addInputPin(String pinNumber) {
        this.inputPinSet.add(pinNumber);
    }

    public void addOutputPin(String pinNumber) {
        this.outputPinSet.add(pinNumber);
    }

    public String getNumberVariable(String userVarName) {
        return this.numberVariableSet.get(userVarName);
    }

    public String getBooleanVariable(String userVarName) {
        return this.booleanVariableSet.get(userVarName);
    }

    public String getStringVariable(String userVarName) {
        return this.stringVariableSet.get(userVarName);
    }

    public void addNumberVariable(String userVarName, String internalName) {
        this.numberVariableSet.put(userVarName, internalName);
    }

    public void addBooleanVariable(String userVarName, String internalName) {
        this.booleanVariableSet.put(userVarName, internalName);
    }

    public void addStringVariable(String userVarName, String internalName) {
        this.stringVariableSet.put(userVarName, internalName);
    }

    public void addFunctionName(Long blockId, String functionName) throws SubroutineNameDuplicatedException {
        if (functionName.equals("loop") || functionName.equals("setup") || this.functionNameSet.contains(functionName)) {
            throw new SubroutineNameDuplicatedException(blockId);
        }
        this.functionNameSet.add(functionName);
    }

    public boolean containFunctionName(String name) {
        return this.functionNameSet.contains(name.trim());
    }

    public void addFunctionNameReturnInt(Long blockId, String functionName) throws SubroutineNameDuplicatedException {
        if (functionName.equals("subroutine-return")) {
            throw new SubroutineNameDuplicatedException(blockId);
        }
        this.functionNameSetReturnInt.add(functionName);
    }

    public void addFunctionNameReturnBoolean(Long blockId, String functionName) throws SubroutineNameDuplicatedException {
        if (functionName.equals("subroutine-return-boolean")) {
            throw new SubroutineNameDuplicatedException(blockId);
        }
        this.functionNameSetReturnBoolean.add(functionName);
    }

    public String buildVariableName() {
        return this.buildVariableName("");
    }

    public String buildVariableName(String reference) {
        ++this.variableCnt;
        String varName = variablePrefix + this.variableCnt + "_";
        int i = 0;
        while (i < reference.length()) {
            char c = reference.charAt(i);
            if (Character.isLetter(c) || Character.isDigit(c) || c == '_') {
                varName = String.valueOf(varName) + c;
            }
            ++i;
        }
        return varName;
    }

    public Workspace getWorkspace() {
        return this.workspace;
    }

    public Block getBlock(Long blockId) {
        return this.workspace.getEnv().getBlock(blockId);
    }

    public void registerBodyTranslateFinishCallback(TranslatorBlock translatorBlock) {
        this.bodyTranslatreFinishCallbackSet.add(translatorBlock);
    }

    public void beforeGenerateHeader() throws SocketNullException, SubroutineNotDeclaredException {
        for (TranslatorBlock translatorBlock : this.bodyTranslatreFinishCallbackSet) {
            translatorBlock.onTranslateBodyFinished();
        }
    }

    public String getRootBlockName() {
        return this.rootBlockName;
    }

    public void setRootBlockName(String rootBlockName) {
        this.rootBlockName = rootBlockName;
    }

    public boolean isScoopProgram() {
        return this.isScoopProgram;
    }

    public void setScoopProgram(boolean isScoopProgram) {
        this.isScoopProgram = isScoopProgram;
    }

    public boolean isGuinoProgram() {
        return this.isGuinoProgram;
    }

    public boolean isVirtuinoProgram() {
        return this.isVirtuinoProgram;
    }

    public void setGuinoProgram(boolean isGuinoProgram) {
        this.isGuinoProgram = isGuinoProgram;
    }

    public void setVirtuinoProgram(boolean isVirtuinoProgram) {
        this.isVirtuinoProgram = isVirtuinoProgram;
    }

    public Set<RenderableBlock> findEntryBlocks() {
        HashSet<RenderableBlock> loopBlockSet = new HashSet<RenderableBlock>();
        Iterable<RenderableBlock> renderableBlocks = this.workspace.getRenderableBlocks();
        for (RenderableBlock renderableBlock : renderableBlocks) {
            Block block = renderableBlock.getBlock();
            if (block.hasPlug() || !Block.NULL.equals(block.getBeforeBlockID())) continue;
            if (block.getGenusName().equals("loop")) {
                loopBlockSet.add(renderableBlock);
            }
            if (block.getGenusName().equals("loop1")) {
                loopBlockSet.add(renderableBlock);
            }
            if (block.getGenusName().equals("loop2")) {
                loopBlockSet.add(renderableBlock);
            }
            if (block.getGenusName().equals("loop3")) {
                loopBlockSet.add(renderableBlock);
            }
            if (block.getGenusName().equals("program")) {
                loopBlockSet.add(renderableBlock);
            }
            if (!block.getGenusName().equals("setup")) continue;
            loopBlockSet.add(renderableBlock);
        }
        return loopBlockSet;
    }

    public Set<RenderableBlock> findSubroutineBlocks() throws SubroutineNameDuplicatedException {
        HashSet<RenderableBlock> subroutineBlockSet = new HashSet<RenderableBlock>();
        Iterable<RenderableBlock> renderableBlocks = this.workspace.getRenderableBlocks();
        for (RenderableBlock renderableBlock : renderableBlocks) {
            Block block = renderableBlock.getBlock();
            if (block.hasPlug() || !Block.NULL.equals(block.getBeforeBlockID())) continue;
            if (block.getGenusName().equals("subroutine")) {
                String functionName = block.getBlockLabel().trim();
                this.addFunctionName(block.getBlockID(), functionName);
                subroutineBlockSet.add(renderableBlock);
            }
            if (block.getGenusName().equals("subroutine-return")) {
                String functionNameReturn = block.getBlockLabel().trim();
                this.addFunctionNameReturnInt(block.getBlockID(), functionNameReturn);
                subroutineBlockSet.add(renderableBlock);
            }
            if (!block.getGenusName().equals("subroutine-return-boolean")) continue;
            String functionNameReturnBoolean = block.getBlockLabel().trim();
            this.addFunctionNameReturnBoolean(block.getBlockID(), functionNameReturnBoolean);
            subroutineBlockSet.add(renderableBlock);
        }
        return subroutineBlockSet;
    }

    public String translate(Set<RenderableBlock> loopBlocks, Set<RenderableBlock> subroutineBlocks) throws SocketNullException, SubroutineNotDeclaredException {
        StringBuilder code = new StringBuilder();
        for (RenderableBlock renderableBlock : loopBlocks) {
            Block loopBlock = renderableBlock.getBlock();
            code.append(this.translate(loopBlock.getBlockID()));
        }
        for (RenderableBlock renderableBlock : subroutineBlocks) {
            Block subroutineBlock = renderableBlock.getBlock();
            code.append(this.translate(subroutineBlock.getBlockID()));
        }
        this.beforeGenerateHeader();
        code.insert(0, this.genreateHeaderCommand());
        return code.toString();
    }

    public Object getInternalData(String name) {
        return this.internalData.get(name);
    }

    public void addInternalData(String name, Object value) {
        this.internalData.put(name, value);
    }
}

