/*
 * Decompiled with CFR 0.152.
 */
package com.ardublock.translator.block.Duinoedu;

import com.ardublock.translator.Translator;
import com.ardublock.translator.block.NumberBlock;
import com.ardublock.translator.block.TranslatorBlock;
import com.ardublock.translator.block.exception.SocketNullException;
import com.ardublock.translator.block.exception.SubroutineNotDeclaredException;

public class Button
extends TranslatorBlock {
    public static final String ARDUBLOCK_DIGITAL_READ_DEFINE = "boolean __ardublockDigitalRead(int pinNumber)\n{\npinMode(pinNumber, INPUT);\nreturn digitalRead(pinNumber);\n}\n\n";

    public Button(Long blockId, Translator translator, String codePrefix, String codeSuffix, String label) {
        super(blockId, translator, codePrefix, codeSuffix, label);
    }

    public String toCode() throws SocketNullException, SubroutineNotDeclaredException {
        TranslatorBlock translatorBlock = this.getRequiredTranslatorBlockAtSocket(0);
        if (translatorBlock instanceof NumberBlock) {
            return this.generateCodeUsingNumberBlock(translatorBlock);
        }
        return this.generateCodeUsingNonNumberBlock(translatorBlock);
    }

    protected String generateCodeUsingNumberBlock(TranslatorBlock translatorBlock) throws SocketNullException, SubroutineNotDeclaredException {
        String number = translatorBlock.toCode();
        this.translator.addInputPin(number.trim());
        String ret = "digitalRead(";
        ret = String.valueOf(ret) + number;
        ret = String.valueOf(ret) + ")";
        return String.valueOf(this.codePrefix) + ret + this.codeSuffix;
    }

    protected String generateCodeUsingNonNumberBlock(TranslatorBlock translatorBlock) throws SocketNullException, SubroutineNotDeclaredException {
        String number = translatorBlock.toCode();
        this.translator.addInputPin(number.trim());
        translatorBlock = this.getRequiredTranslatorBlockAtSocket(1);
        String push = translatorBlock.toCode();
        this.translator.addDefinitionCommand(ARDUBLOCK_DIGITAL_READ_DEFINE);
        String ret = String.valueOf(push) + "__ardublockDigitalRead(";
        ret = String.valueOf(ret) + number + ")";
        return String.valueOf(this.codePrefix) + ret + this.codeSuffix;
    }
}

