/*
 * Decompiled with CFR 0.152.
 */
package cc.arduino.plugins.wifi101.certs;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPublicKey;
import java.util.Arrays;
import java.util.Date;
import javax.xml.bind.DatatypeConverter;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1OutputStream;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.DERPrintableString;
import org.bouncycastle.asn1.DLSequence;
import org.bouncycastle.asn1.DLSet;
import org.bouncycastle.asn1.x509.Time;

public class WiFi101Certificate {
    byte[] data;
    String subject;
    String hash;

    public WiFi101Certificate(X509Certificate x509Certificate) throws Exception, NoSuchAlgorithmException, IOException {
        String string = x509Certificate.getPublicKey().getAlgorithm();
        if (!string.equals("RSA") || !(x509Certificate.getPublicKey() instanceof RSAPublicKey)) {
            throw new Exception("SSL Certificate must have an RSA Public Key");
        }
        RSAPublicKey rSAPublicKey = (RSAPublicKey)x509Certificate.getPublicKey();
        byte[] byArray = rSAPublicKey.getPublicExponent().toByteArray();
        byte[] byArray2 = WiFi101Certificate.shortToBytes(byArray.length);
        byte[] byArray3 = rSAPublicKey.getModulus().toByteArray();
        if (byArray3.length == 257 || byArray3[0] == 0) {
            byArray3 = Arrays.copyOfRange(byArray3, 1, byArray3.length);
        }
        byte[] byArray4 = WiFi101Certificate.shortToBytes(byArray3.length);
        byte[] byArray5 = WiFi101Certificate.getSubjectValueHash(x509Certificate);
        byte[] byArray6 = WiFi101Certificate.encodeTimestamp(x509Certificate.getNotBefore());
        byte[] byArray7 = WiFi101Certificate.encodeTimestamp(x509Certificate.getNotAfter());
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byteArrayOutputStream.write(byArray5);
        byteArrayOutputStream.write(byArray4);
        byteArrayOutputStream.write(byArray2);
        byteArrayOutputStream.write(byArray6);
        byteArrayOutputStream.write(byArray7);
        byteArrayOutputStream.write(byArray3);
        byteArrayOutputStream.write(byArray);
        while (byteArrayOutputStream.size() % 4 != 0) {
            byteArrayOutputStream.write(255);
        }
        this.data = byteArrayOutputStream.toByteArray();
        byte[] byArray8 = MessageDigest.getInstance("SHA-1").digest(this.data);
        this.hash = DatatypeConverter.printHexBinary((byte[])byArray8).substring(0, 6);
    }

    public String toString() {
        return "(" + this.hash + ")";
    }

    private static byte[] shortToBytes(int n) {
        byte[] byArray = new byte[]{(byte)n, (byte)(n >> 8)};
        return byArray;
    }

    private static byte[] encodeTimestamp(Date date) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ASN1OutputStream aSN1OutputStream = new ASN1OutputStream((OutputStream)byteArrayOutputStream);
        aSN1OutputStream.writeObject((ASN1Encodable)new Time(date));
        return Arrays.copyOfRange(byteArrayOutputStream.toByteArray(), 2, 22);
    }

    private static byte[] getSubjectValueHash(X509Certificate x509Certificate) throws NoSuchAlgorithmException, IOException {
        MessageDigest messageDigest = MessageDigest.getInstance("SHA-1");
        ASN1InputStream aSN1InputStream = new ASN1InputStream(x509Certificate.getSubjectX500Principal().getEncoded());
        while (aSN1InputStream.available() > 0) {
            ASN1Primitive aSN1Primitive = aSN1InputStream.readObject();
            messageDigest.update(WiFi101Certificate.extractPrintableString((ASN1Encodable)aSN1Primitive));
        }
        aSN1InputStream.close();
        return messageDigest.digest();
    }

    private static byte[] extractPrintableString(ASN1Encodable aSN1Encodable) throws IOException {
        int n;
        DLSequence dLSequence;
        if (aSN1Encodable instanceof DERPrintableString) {
            DERPrintableString dERPrintableString = (DERPrintableString)aSN1Encodable;
            return dERPrintableString.getString().getBytes();
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        if (aSN1Encodable instanceof DLSequence) {
            dLSequence = (DLSequence)aSN1Encodable;
            for (n = 0; n < dLSequence.size(); ++n) {
                byteArrayOutputStream.write(WiFi101Certificate.extractPrintableString(dLSequence.getObjectAt(n)));
            }
        }
        if (aSN1Encodable instanceof DLSet) {
            dLSequence = (DLSet)aSN1Encodable;
            for (n = 0; n < dLSequence.size(); ++n) {
                byteArrayOutputStream.write(WiFi101Certificate.extractPrintableString(dLSequence.getObjectAt(n)));
            }
        }
        return byteArrayOutputStream.toByteArray();
    }

    public byte[] getEncoded() {
        return (byte[])this.data.clone();
    }
}

