/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.blocks.codeblockutil;

import edu.mit.blocks.codeblockutil.CButton;
import edu.mit.blocks.codeblockutil.CGraphite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;

public class CGraphiteSquareButton
extends CButton {
    private static final long serialVersionUID = 328149080220L;

    public CGraphiteSquareButton(String text) {
        super(Color.black, CGraphite.blue, text);
    }

    @Override
    public void paint(Graphics g) {
        Color bottomColoring;
        Color topColoring;
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int buttonHeight = this.getHeight();
        int buttonWidth = this.getWidth();
        if (this.pressed || this.selected) {
            if (this.focus) {
                topColoring = this.selectedColor.darker().darker().darker();
                bottomColoring = this.selectedColor;
            } else {
                topColoring = this.selectedColor.darker().darker().darker();
                bottomColoring = this.selectedColor;
            }
        } else if (this.focus) {
            topColoring = this.buttonColor;
            bottomColoring = Color.darkGray;
        } else {
            topColoring = this.buttonColor;
            bottomColoring = this.buttonColor;
        }
        g2.setPaint(new GradientPaint(0.0f, 0.0f, topColoring, 0.0f, buttonHeight, bottomColoring, false));
        g2.fillRect(0, 0, buttonWidth, buttonHeight);
        int highlightHeight = buttonHeight / 2 - 2;
        int highlightWidth = buttonWidth;
        if (this.pressed || this.selected) {
            if (this.focus) {
                topColoring = Color.white;
                bottomColoring = this.selectedColor;
            } else {
                topColoring = Color.white;
                bottomColoring = this.selectedColor;
            }
        } else if (this.focus) {
            topColoring = Color.white;
            bottomColoring = Color.darkGray;
        } else {
            topColoring = Color.gray;
            bottomColoring = Color.darkGray;
        }
        g2.setPaint(new GradientPaint(0.0f, 0.0f, topColoring, 0.0f, buttonHeight, bottomColoring, false));
        g2.fillRect(0, 0, highlightWidth, highlightHeight);
        g2.setColor(Color.DARK_GRAY);
        g2.setStroke(new BasicStroke(2.0f));
        g2.drawRect(0, 0, buttonWidth - 1, buttonHeight - 1);
        if (this.getText() != null) {
            g2.setColor(Color.white);
            Font font = g2.getFont().deriveFont((float)((double)buttonHeight * 0.3));
            g2.setFont(font);
            FontMetrics metrics = g2.getFontMetrics();
            Rectangle2D textBounds = metrics.getStringBounds(this.getText(), g2);
            float x = (float)((double)(this.getWidth() / 2) - textBounds.getWidth() / 2.0);
            float y = (float)((double)(this.getHeight() / 2) + textBounds.getHeight() / 2.0) - (float)metrics.getDescent();
            g2.drawString(this.getText(), x, y);
        }
    }
}

