/*
 * Decompiled with CFR 0.152.
 */
package com.leapmotion.leap;

import com.leapmotion.leap.Interface;
import com.leapmotion.leap.LeapJNI;
import com.leapmotion.leap.Pointable;
import com.leapmotion.leap.Screen;
import com.leapmotion.leap.Vector;
import java.util.Iterator;

public class ScreenList
extends Interface
implements Iterable<Screen> {
    private long swigCPtr;

    public ScreenList(long l, boolean bl) {
        super(LeapJNI.ScreenList_SWIGUpcast(l), bl);
        this.swigCPtr = l;
    }

    public static long getCPtr(ScreenList screenList) {
        return screenList == null ? 0L : screenList.swigCPtr;
    }

    protected void finalize() {
        this.delete();
    }

    @Override
    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                LeapJNI.delete_ScreenList(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
        super.delete();
    }

    @Override
    public Iterator<Screen> iterator() {
        return new ScreenListIterator();
    }

    public ScreenList() {
        this(LeapJNI.new_ScreenList(), true);
    }

    public int count() {
        return LeapJNI.ScreenList_count(this.swigCPtr, this);
    }

    public boolean isEmpty() {
        return LeapJNI.ScreenList_isEmpty(this.swigCPtr, this);
    }

    public Screen get(int n) {
        return new Screen(LeapJNI.ScreenList_get(this.swigCPtr, this, n), true);
    }

    public Screen closestScreenHit(Pointable pointable) {
        return new Screen(LeapJNI.ScreenList_closestScreenHit__SWIG_0(this.swigCPtr, this, Pointable.getCPtr(pointable), pointable), true);
    }

    public Screen closestScreenHit(Vector vector, Vector vector2) {
        return new Screen(LeapJNI.ScreenList_closestScreenHit__SWIG_1(this.swigCPtr, this, Vector.getCPtr(vector), vector, Vector.getCPtr(vector2), vector2), true);
    }

    public Screen closestScreen(Vector vector) {
        return new Screen(LeapJNI.ScreenList_closestScreen(this.swigCPtr, this, Vector.getCPtr(vector), vector), true);
    }

    public class ScreenListIterator
    implements Iterator<Screen> {
        int index = 0;

        @Override
        public boolean hasNext() {
            return this.index < ScreenList.this.count();
        }

        @Override
        public Screen next() {
            return ScreenList.this.get(this.index++);
        }

        @Override
        public void remove() {
        }
    }
}

