/*
 * Decompiled with CFR 0.152.
 */
package de.voidplus.leapmotion;

import de.voidplus.leapmotion.Hand;
import de.voidplus.leapmotion.LeapMotion;
import java.util.ArrayList;
import processing.core.PApplet;

public abstract class Gesture {
    protected PApplet parent;
    protected LeapMotion leap;
    private com.leapmotion.leap.Gesture gesture;

    public Gesture(PApplet parent, LeapMotion leap, com.leapmotion.leap.Gesture gesture) {
        this.parent = parent;
        this.leap = leap;
        this.gesture = gesture;
    }

    public boolean isValid() {
        return this.gesture.isValid();
    }

    public static boolean isValid(com.leapmotion.leap.Gesture gesture) {
        return gesture.isValid();
    }

    public int getId() {
        return this.gesture.id();
    }

    public int getType() {
        if (this.isValid()) {
            switch (this.gesture.type()) {
                case TYPE_CIRCLE: {
                    return 0;
                }
                case TYPE_KEY_TAP: {
                    return 1;
                }
                case TYPE_SCREEN_TAP: {
                    return 2;
                }
                case TYPE_SWIPE: {
                    return 3;
                }
            }
            return -1;
        }
        return -1;
    }

    public long getDuration() {
        return this.gesture.duration();
    }

    public float getDurationInSeconds() {
        return this.gesture.durationSeconds();
    }

    public boolean hasHands() {
        return !this.gesture.hands().isEmpty();
    }

    public ArrayList<Hand> getHands() {
        ArrayList<Hand> hands = new ArrayList<Hand>();
        if (this.hasHands()) {
            for (com.leapmotion.leap.Hand hand : this.gesture.hands()) {
                hands.add(new Hand(this.parent, this.leap, hand));
            }
        }
        return hands;
    }

    public int countHands() {
        if (this.hasHands()) {
            return this.gesture.hands().count();
        }
        return 0;
    }
}

