/*
 * Decompiled with CFR 0.152.
 */
package com.leapmotion.leap;

import com.leapmotion.leap.LeapJNI;

public class Vector {
    private long swigCPtr;
    protected boolean swigCMemOwn;

    public Vector(long l, boolean bl) {
        this.swigCMemOwn = bl;
        this.swigCPtr = l;
    }

    public static long getCPtr(Vector vector) {
        return vector == null ? 0L : vector.swigCPtr;
    }

    protected void finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                LeapJNI.delete_Vector(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    public float[] toFloatArray() {
        return new float[]{this.getX(), this.getY(), this.getZ()};
    }

    public Vector() {
        this(LeapJNI.new_Vector__SWIG_0(), true);
    }

    public Vector(float f, float f2, float f3) {
        this(LeapJNI.new_Vector__SWIG_1(f, f2, f3), true);
    }

    public Vector(Vector vector) {
        this(LeapJNI.new_Vector__SWIG_2(Vector.getCPtr(vector), vector), true);
    }

    public static Vector zero() {
        return new Vector(LeapJNI.Vector_zero(), false);
    }

    public static Vector xAxis() {
        return new Vector(LeapJNI.Vector_xAxis(), false);
    }

    public static Vector yAxis() {
        return new Vector(LeapJNI.Vector_yAxis(), false);
    }

    public static Vector zAxis() {
        return new Vector(LeapJNI.Vector_zAxis(), false);
    }

    public static Vector left() {
        return new Vector(LeapJNI.Vector_left(), false);
    }

    public static Vector right() {
        return new Vector(LeapJNI.Vector_right(), false);
    }

    public static Vector down() {
        return new Vector(LeapJNI.Vector_down(), false);
    }

    public static Vector up() {
        return new Vector(LeapJNI.Vector_up(), false);
    }

    public static Vector forward() {
        return new Vector(LeapJNI.Vector_forward(), false);
    }

    public static Vector backward() {
        return new Vector(LeapJNI.Vector_backward(), false);
    }

    public float magnitude() {
        return LeapJNI.Vector_magnitude(this.swigCPtr, this);
    }

    public float magnitudeSquared() {
        return LeapJNI.Vector_magnitudeSquared(this.swigCPtr, this);
    }

    public float distanceTo(Vector vector) {
        return LeapJNI.Vector_distanceTo(this.swigCPtr, this, Vector.getCPtr(vector), vector);
    }

    public float angleTo(Vector vector) {
        return LeapJNI.Vector_angleTo(this.swigCPtr, this, Vector.getCPtr(vector), vector);
    }

    public float pitch() {
        return LeapJNI.Vector_pitch(this.swigCPtr, this);
    }

    public float yaw() {
        return LeapJNI.Vector_yaw(this.swigCPtr, this);
    }

    public float roll() {
        return LeapJNI.Vector_roll(this.swigCPtr, this);
    }

    public float dot(Vector vector) {
        return LeapJNI.Vector_dot(this.swigCPtr, this, Vector.getCPtr(vector), vector);
    }

    public Vector cross(Vector vector) {
        return new Vector(LeapJNI.Vector_cross(this.swigCPtr, this, Vector.getCPtr(vector), vector), true);
    }

    public Vector normalized() {
        return new Vector(LeapJNI.Vector_normalized(this.swigCPtr, this), true);
    }

    public Vector opposite() {
        return new Vector(LeapJNI.Vector_opposite(this.swigCPtr, this), true);
    }

    public Vector plus(Vector vector) {
        return new Vector(LeapJNI.Vector_plus(this.swigCPtr, this, Vector.getCPtr(vector), vector), true);
    }

    public Vector minus(Vector vector) {
        return new Vector(LeapJNI.Vector_minus(this.swigCPtr, this, Vector.getCPtr(vector), vector), true);
    }

    public Vector times(float f) {
        return new Vector(LeapJNI.Vector_times(this.swigCPtr, this, f), true);
    }

    public Vector divide(float f) {
        return new Vector(LeapJNI.Vector_divide(this.swigCPtr, this, f), true);
    }

    public String toString() {
        return LeapJNI.Vector_toString(this.swigCPtr, this);
    }

    public boolean equals(Vector vector) {
        return LeapJNI.Vector_equals(this.swigCPtr, this, Vector.getCPtr(vector), vector);
    }

    public boolean isValid() {
        return LeapJNI.Vector_isValid(this.swigCPtr, this);
    }

    public float get(long l) {
        return LeapJNI.Vector_get(this.swigCPtr, this, l);
    }

    public void setX(float f) {
        LeapJNI.Vector_x_set(this.swigCPtr, this, f);
    }

    public float getX() {
        return LeapJNI.Vector_x_get(this.swigCPtr, this);
    }

    public void setY(float f) {
        LeapJNI.Vector_y_set(this.swigCPtr, this, f);
    }

    public float getY() {
        return LeapJNI.Vector_y_get(this.swigCPtr, this);
    }

    public void setZ(float f) {
        LeapJNI.Vector_z_set(this.swigCPtr, this, f);
    }

    public float getZ() {
        return LeapJNI.Vector_z_get(this.swigCPtr, this);
    }
}

