/*
 * Decompiled with CFR 0.152.
 */
package cc.arduino.packages.discoverers.network;

import cc.arduino.packages.discoverers.network.NetworkTopologyListener;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import javax.jmdns.NetworkTopologyDiscovery;

public class NetworkChecker
extends TimerTask {
    private final NetworkTopologyListener topologyListener;
    private final NetworkTopologyDiscovery topology;
    private Set<InetAddress> knownAddresses;

    public NetworkChecker(NetworkTopologyListener topologyListener, NetworkTopologyDiscovery topology) {
        this.topologyListener = topologyListener;
        this.topology = topology;
        this.knownAddresses = Collections.synchronizedSet(new HashSet());
    }

    public void start(Timer timer) {
        timer.schedule((TimerTask)this, 0L, 3000L);
    }

    @Override
    public void run() {
        if (!this.hasNetworkInterfaces()) {
            return;
        }
        try {
            InetAddress[] curentAddresses = this.topology.getInetAddresses();
            HashSet<InetAddress> current = new HashSet<InetAddress>(curentAddresses.length);
            for (InetAddress address2 : curentAddresses) {
                current.add(address2);
                if (this.knownAddresses.contains(address2)) continue;
                this.topologyListener.inetAddressAdded(address2);
            }
            this.knownAddresses.stream().filter(address -> !current.contains(address)).forEach(this.topologyListener::inetAddressRemoved);
            this.knownAddresses = current;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private boolean hasNetworkInterfaces() {
        try {
            return NetworkInterface.getNetworkInterfaces() != null;
        }
        catch (SocketException e) {
            return false;
        }
    }
}

