/*
 * Decompiled with CFR 0.152.
 */
package processing.app;

import cc.arduino.files.DeleteFilesOnShutdown;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import processing.app.BaseNoGui;
import processing.app.I18n;
import processing.app.PreferencesData;
import processing.app.SketchFile;
import processing.app.helpers.FileUtils;

public class Sketch {
    public static final String DEFAULT_SKETCH_EXTENSION = "ino";
    public static final List<String> OLD_SKETCH_EXTENSIONS = Arrays.asList("pde");
    public static final List<String> SKETCH_EXTENSIONS = Stream.concat(Stream.of("ino"), OLD_SKETCH_EXTENSIONS.stream()).collect(Collectors.toList());
    public static final List<String> OTHER_ALLOWED_EXTENSIONS = Arrays.asList("c", "cpp", "h", "hh", "hpp", "s");
    public static final List<String> EXTENSIONS = Stream.concat(SKETCH_EXTENSIONS.stream(), OTHER_ALLOWED_EXTENSIONS.stream()).collect(Collectors.toList());
    private File folder;
    private List<SketchFile> files = new ArrayList<SketchFile>();
    private File buildPath;
    private static final Comparator<SketchFile> CODE_DOCS_COMPARATOR = new Comparator<SketchFile>(){

        @Override
        public int compare(SketchFile x, SketchFile y) {
            if (x.isPrimary() && !y.isPrimary()) {
                return -1;
            }
            if (y.isPrimary() && !x.isPrimary()) {
                return 1;
            }
            return x.getFileName().compareTo(y.getFileName());
        }
    };

    Sketch(File file) throws IOException {
        this.folder = file.getParentFile();
        this.files = this.listSketchFiles(true);
    }

    public static File checkSketchFile(File file) {
        String fileName = file.getName();
        File parent = file.getParentFile();
        String parentName = parent.getName();
        String pdeName = parentName + ".pde";
        File altPdeFile = new File(parent, pdeName);
        String inoName = parentName + ".ino";
        File altInoFile = new File(parent, inoName);
        if (pdeName.equals(fileName) || inoName.equals(fileName)) {
            return file;
        }
        if (altPdeFile.exists()) {
            return altPdeFile;
        }
        if (altInoFile.exists()) {
            return altInoFile;
        }
        return null;
    }

    public boolean reload() throws IOException {
        List<SketchFile> reloaded = this.listSketchFiles(false);
        if (!reloaded.equals(this.files)) {
            this.files = reloaded;
            return true;
        }
        return false;
    }

    private List<SketchFile> listSketchFiles(boolean showWarnings) throws IOException {
        TreeSet<SketchFile> result = new TreeSet<SketchFile>(CODE_DOCS_COMPARATOR);
        for (File file : FileUtils.listFiles(this.folder, false, EXTENSIONS)) {
            if (BaseNoGui.isSanitaryName(file.getName())) {
                result.add(new SketchFile(this, file));
                continue;
            }
            if (!showWarnings) continue;
            System.err.println(I18n.format(I18n.tr("File name {0} is invalid: ignored"), file.getName()));
        }
        if (result.size() == 0) {
            throw new IOException(I18n.tr("No valid code files found"));
        }
        return new ArrayList<SketchFile>(result);
    }

    public File prepareDataFolder() {
        File dataFolder = this.getDataFolder();
        if (!dataFolder.exists()) {
            dataFolder.mkdirs();
        }
        return dataFolder;
    }

    public void save() throws IOException {
        for (SketchFile file : this.getFiles()) {
            if (!file.isModified()) continue;
            file.save();
        }
    }

    public int getCodeCount() {
        return this.files.size();
    }

    public SketchFile[] getFiles() {
        return this.files.toArray(new SketchFile[0]);
    }

    public SketchFile getPrimaryFile() {
        return this.files.get(0);
    }

    public String getMainFilePath() {
        return this.getPrimaryFile().getFile().getAbsolutePath();
    }

    public SketchFile getFile(int i) {
        return this.files.get(i);
    }

    public File getBuildPath() throws IOException {
        if (this.buildPath == null) {
            if (PreferencesData.get("build.path") != null) {
                this.buildPath = BaseNoGui.absoluteFile(PreferencesData.get("build.path"));
                Files.createDirectories(this.buildPath.toPath(), new FileAttribute[0]);
            } else {
                this.buildPath = FileUtils.createTempFolder("arduino_build_");
                DeleteFilesOnShutdown.add(this.buildPath);
            }
        }
        return this.buildPath;
    }

    protected void removeFile(SketchFile which) {
        if (!this.files.remove(which)) {
            System.err.println("removeCode: internal error.. could not find code");
        }
    }

    public String getName() {
        return this.folder.getName();
    }

    public File getFolder() {
        return this.folder;
    }

    public File getDataFolder() {
        return new File(this.folder, "data");
    }

    public boolean isModified() {
        for (SketchFile file : this.files) {
            if (!file.isModified()) continue;
            return true;
        }
        return false;
    }

    public int findFileIndex(File filename) {
        int i = 0;
        for (SketchFile file : this.files) {
            if (file.getFile().equals(filename)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    protected File checkNewFoldername(File newFolder) throws IOException {
        String newPrimary = FileUtils.addExtension(newFolder.getName(), DEFAULT_SKETCH_EXTENSION);
        if (newFolder.exists()) {
            String msg = I18n.format(I18n.tr("Sorry, the folder \"{0}\" already exists."), newFolder.getAbsoluteFile());
            throw new IOException(msg);
        }
        if (newFolder.getName() != this.folder.getName()) {
            this.checkNewFilename(new File(this.folder, newPrimary));
        }
        return new File(newFolder, newPrimary);
    }

    protected void checkNewFilename(File newFile) throws IOException {
        if (this.findFileIndex(newFile) >= 0) {
            String msg = I18n.format(I18n.tr("The sketch already contains a file named \"{0}\""), newFile.getName());
            throw new IOException(msg);
        }
    }

    public void renameTo(File newFolder) throws IOException {
        File newPrimary = this.checkNewFoldername(newFolder);
        if (!this.getFolder().renameTo(newFolder)) {
            throw new IOException(I18n.tr("Failed to rename sketch folder"));
        }
        this.folder = newFolder;
        for (SketchFile file : this.files) {
            file.renamedTo(new File(newFolder, file.getFileName()));
        }
        this.getPrimaryFile().renameTo(newPrimary.getName());
    }

    public SketchFile addFile(String newName) throws IOException {
        File newFile = new File(this.folder, newName);
        this.checkNewFilename(newFile);
        SketchFile sketchFile = new SketchFile(this, newFile);
        this.files.add(sketchFile);
        Collections.sort(this.files, CODE_DOCS_COMPARATOR);
        return sketchFile;
    }

    public void saveAs(File newFolder) throws IOException {
        File newPrimary = this.checkNewFoldername(newFolder);
        if (!newFolder.mkdirs()) {
            String msg = I18n.format(I18n.tr("Could not create directory \"{0}\""), newFolder.getAbsolutePath());
            throw new IOException(msg);
        }
        for (SketchFile file : this.files) {
            if (file.isPrimary()) {
                file.saveAs(newPrimary);
                continue;
            }
            file.saveAs(new File(newFolder, file.getFileName()));
        }
        this.folder = newFolder;
        if (this.getDataFolder().exists()) {
            File newDataFolder = new File(newFolder, "data");
            FileUtils.copy(this.getDataFolder(), newDataFolder);
        }
    }

    void delete() {
        FileUtils.recursiveDelete(this.folder);
    }
}

