/*
 * Decompiled with CFR 0.152.
 */
package processing.app.packages;

import java.io.File;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import processing.app.helpers.FileUtils;
import processing.app.packages.UserLibrary;

public class LibraryList
extends LinkedList<UserLibrary> {
    public LibraryList(LibraryList libs) {
        super(libs);
    }

    public LibraryList() {
    }

    public LibraryList(List<UserLibrary> ideLibs) {
        super(ideLibs);
    }

    public synchronized UserLibrary getByName(String name) {
        for (UserLibrary l : this) {
            if (!l.getName().equals(name)) continue;
            return l;
        }
        return null;
    }

    public synchronized void addOrReplaceArchAware(UserLibrary lib) {
        this.addOrReplace(lib, true);
    }

    public synchronized void addOrReplace(UserLibrary lib) {
        this.addOrReplace(lib, false);
    }

    public synchronized void addOrReplace(UserLibrary lib, boolean archAware) {
        this.remove(lib, archAware);
        this.add(lib);
    }

    public synchronized void remove(UserLibrary lib, boolean archAware) {
        UserLibrary l = this.getByName(lib.getName());
        if (l != null && (!archAware || lib.getArchitectures().contains("*") || lib.getArchitectures().containsAll(l.getArchitectures()))) {
            super.remove(l);
        }
    }

    public synchronized void sort() {
        Collections.sort(this, UserLibrary.CASE_INSENSITIVE_ORDER);
    }

    public synchronized LibraryList filterLibrariesInSubfolder(File subFolder) {
        LibraryList res = new LibraryList();
        for (UserLibrary lib : this) {
            if (!FileUtils.isSubDirectory(subFolder, lib.getInstalledFolder())) continue;
            res.add(lib);
        }
        return res;
    }

    public synchronized boolean hasLibrary(UserLibrary lib) {
        for (UserLibrary l : this) {
            if (l != lib) continue;
            return true;
        }
        return false;
    }
}

